<?php echo view('public/includes/header'); ?>



<div class="container py-5">
	<div class="row  g-0">
		<div class="col-md-12 ">
			<h3 class="mb-3 px-3">Dashboard</h3>
		</div>

		<?php 
			$userData = getLoginUserData();
			// echo "<pre>";
			// print_r($userData);
			// echo "</pre>";
			// if(empty($userData->ac_street_address) OR empty($userData->ac_zip)){ ?>

			<div class="col-md-6 p-4">
				<h5>Complete Your Profile</h5>

				<?php flash_data(); ?>

				<div class="py-4 pt-2">
					<form action="<?= site_url('user/profile/complete'); ?>" method="post">

						<div class="mb-3">
							<label class="form-label">Gender</label>
							<select name="gender" class="form-select rounded-0">
								<option value="">Select</option>
								<?php 

								if($genders)
								{
									foreach ($genders as $row) {

									if($userData->ac_gender == $row->gender_id){
									 ?>
										
										<option value="<?= $row->gender_id ?>" selected><?= $row->gender_name ?></option>
									<?php }else{ ?>
										<option value="<?= $row->gender_id ?>"><?= $row->gender_name ?></option>
									<?php }
									}
								} 

								?>

							</select>
						</div>
						<div class="row">
							<div class="col-md-4 mb-3">
								<label class="form-label">Country<sup class="text-danger fw-bold">*</sup></label>
								<select name="country" class="form-select rounded-0" id="country" required>
									<option value="">Select</option>
										<?php 
										if($countrys)
										{
											foreach ($countrys as $row) {
												if($row->country_id == $userData->ac_country){
											 ?>	
												<option value="<?= $row->country_id ?>" selected><?= $row->country_name ?></option>
											<?php }else{ ?>
												<option value="<?= $row->country_id ?>"><?= $row->country_name ?></option>
											<?php }
										}
										} 
										?>
								</select>
							</div>
							<div class="col-md-4 mb-3">
								<label class="form-label">State<sup class="text-danger fw-bold">*</sup></label>
								<select name="state" id="ajax_state_list" class="form-select rounded-0" required>
										<?php 
										if($state)
										{
											foreach ($state as $row) {
												if($row['state_id'] == $userData->ac_state){
											 ?>	
												<option value="<?= $row['state_id'] ?>" selected><?= $row['state_title'] ?></option>
											<?php }else{ ?>
												<option value="<?= $row['state_id'] ?>"><?= $row['state_title'] ?></option>
											<?php }
										}
										} 
										?>		
								</select>
							</div>

							<div class="col-md-4 mb-3">
								<label class="form-label">City<sup class="text-danger fw-bold">*</sup></label>
								<select name="city" class="form-select rounded-0" id="ajax_city_list" required>
										<?php 
										if($citys)
										{
											foreach ($citys as $row) {
												if($row['city_id'] == $userData->ac_city){
											 ?>	
												<option value="<?= $row['city_id'] ?>" selected><?= $row['city_name'] ?></option>
											<?php }else{ ?>
												<option value="<?= $row['city_id'] ?>"><?= $row['city_name'] ?></option>
											<?php }
										}
										} 
										?>
								</select>
							</div>

						</div>
						<div class="mb-3">
							<label class="form-label">Zip<sup class="text-danger fw-bold">*</sup></label>
							<input type="text" name="zip" value="<?= $userData->ac_zip ?>" class="form-control rounded-0" required>
						</div>
						<div class="mb-3">
							<label class="form-label">Full Address <sup class="text-danger fw-bold">*</sup></label>
							<textarea class="form-control rounded-0" rows="3" name="full_address" required><?= $userData->ac_street_address ?></textarea>
						</div>
						<div class="">
							<button class="btn btn-primary rounded-0">Complete Profile</button>
						</div>
					</form>
				</div>

			</div>

		<?php
		//  }else{
		// 	echo "Your Profile already Completed";
		// }  
		?>


			<div class="col-md-6 bg-light py-3 px-4">
				<h5>Quotation History</h5>
				<div class="p-3 bg-white mt-2">
					<table class="table table-striped">
						<thead>
							<tr>
								<!-- <th>Sr.No.</th> -->
								<th>Quotation No.</th>
								<th>Total</th>
								<th>Status</th>
							</tr>
						</thead>
						<tbody>
							<?php $i=1; foreach($order_list as $ol){ ?>
								<tr>
									<!-- <td><?= $i; ?></td> -->
									<td><a href="<?= site_url('print/accept-quotation?token='.$ol->o_hash) ?>" target="_blank" class="fw-bold">#<?= $ol->o_id; ?></a></td>
									<td align="right"><?= currency_filter($ol->o_total); ?></td>
									<td>
										<?php 
											if($ol->o_status == 'P')
											{
												echo '<span class="bg-danger py-1 px-2 text-white rounded">Pending</span>';
											}elseif($ol->o_status == 'D')
											{
												echo '<span class="bg-success py-1 px-2 text-white rounded">Complate</span>';
											}elseif($ol->o_status == 'PP')
											{
												echo '<span class="bg-warning py-1 px-2 text-white rounded">Payment Pending</span>';
											}elseif($ol->o_status == 'PD')
											{
												echo '<span class="bg-info py-1 px-2 text-white rounded">Payment Done</span>';
											}
										 ?>
									</td>
								</tr>
							<?php $i++; } ?>
						</tbody>
					</table>
				</div>
			</div>




	</div>
</div>


<script>
	$(document).ready(function(){

		// Country Select And Display State
	    $('#country').change(function(){
	        const country_id = $(this).val();
	        $.ajax({
	            url:'<?= base_url('ajax/state/list?country_id='); ?>'+country_id,
	            type:'POST',
	            success:function(data)
	            {
	            	$('#ajax_state_list').html('');	
	            	$('#ajax_city_list').html('');
	            	$('#ajax_state_list').append(data);	            
	            }
	        });
	    });

	    // State Select And Display City
	    $('#ajax_state_list').change(function(){
	        const state_id = $(this).val();
	        $.ajax({
	            url:'<?= base_url('ajax/city/list?state_id='); ?>'+state_id,
	            type:'POST',
	            success:function(data)
	            {
	            	$('#ajax_city_list').html('');
	            	$('#ajax_city_list').append(data);	            
	            }
	        });
	    });


	});
</script>

<?php echo view('public/includes/footer'); ?>
