<?php  ?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title><?= $seo['title']; ?></title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="<?= $seo['keywords']; ?>" name="keywords">
    <meta content="<?= $seo['description']; ?>" name="description">

    <link href="<?= SITE_MEDIA ?>front/img/favicon.icon" rel="icon">

    <link rel="preload" href="<?= SITE_MEDIA ?>front/css/Gill Sans.otf" as="font" type="font/woff2" crossorigin>
    <!--<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" />-->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">
   
    <link href="<?= SITE_MEDIA ?>front/css/animate-design.css" rel="stylesheet">
    <link href="<?= SITE_MEDIA ?>front/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?= SITE_MEDIA ?>front/css/style.css" rel="stylesheet">
    
    <!-- Dynamic Includes -->
    <?php if(isset($page_type)){ ?>
        <?php if($page_type == 'home'){ ?>
            <link href="<?= SITE_MEDIA ?>front/css/home.css" rel="stylesheet">
        <?php }elseif($page_type == 'list'){ ?>
            <link href="<?= SITE_MEDIA ?>front/css/list.css" rel="stylesheet">
        <?php }elseif($page_type == 'details'){ ?>
        
        
            <link href="<?= SITE_MEDIA ?>front/css/details.css" rel="stylesheet">
             <link rel="stylesheet" href="https://unpkg.com/flickity@2/dist/flickity.min.css">
    <!--<link href="<?= SITE_MEDIA ?>front/css/owl.carousel.min.css" rel="stylesheet">-->
    <!--<link href="<?= SITE_MEDIA ?>front/css/owl.theme.default.min.css" rel="stylesheet">-->
            
            
        <?php } ?>
    <?php } ?>


   
    
    



    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

<style>
    
.product_items_parent .img-fluid {
    max-width: 100%;
    height: auto;
    max-height: auto;
    min-height: 252px !important;
    width:100%;
}


.menu-cart
{
    position: relative;
    padding: 15px;
    background: #eb5933;
    color: #fff;
    border-radius: 3px;
}
.menu-cart:hover
{
    color: #fff;
}

.menu-cart::after
{
    content: attr(data-after);;
    position: absolute;
    right: 5px;
    top: -2px;
}
.decrement_qty
{
    border-radius: 3px 0px 0px 3px !important;
}
.increment_qty
{
    border-radius: 0px 3px 3px 0px !important;
}



@media(max-width:  1190px)
{
    .dropdown-menu.small {
        position: absolute !important;
        height: 400px;
        width: 100%;
        top: 93px !important;
        text-align: center;
    }
    .dropdown-menu.small.show {
        display: block;
        position: absolute !important;
        height: 400px;
        width: 100%;
        top: 93px !important;
        text-align: center;
    }
    .dropdown-menu.small.show a
    {
        margin: auto;
    }
}



.top-heading h2 {
    text-align: center;
    padding: 13px 0 0 0;
    color: #eb5933;
    letter-spacing: 10px;
    font-size: 33px;
    margin: 15px 0 15px -324px;
    font-weight: 700;
}
.form-control:focus {
    color: #212529;
    background-color: #fff;
    border-color: #a2a2a2;
    outline: 0;
    box-shadow: none;
}
.menu ul {
    margin: 0 0 0 56px;
}
.menu{
    border-right: 1px dashed #b6abab;
}
.menu .cat-heading {
    font-size: 15px;
    color: #eb5933;
    border-bottom: 1px solid #eb5933;
    width: fit-content;
    text-transform: uppercase;
    margin: 0 0 14px 55px;
    width: 95%;
    justify-content: space-between;
}
.menu ul li a {

    border-bottom: none;
    color: #000;
    font-size: 14px;
}
.menu ul li i{
    display: none;
}

i.bi.bi-plus {
    display: none;
}
/* ============ mobile view ============ */
@media(max-width: 991px){

    i.bi.bi-plus {
    display: block !important;
}
.top-heading h2 {
     text-align: left; 
    font-size: 17px;
    margin: 0px 0 15px 0px;

}
.menu ul {
    margin: 0 0 0 14px;
    border-right: none;
}
.navbar-light .navbar-toggler {
    margin: 0 27px 0 0px;
}
hr{
    width: 100%;
}
.d-flex {
    display: none !important;
}
.menu-img img{
    display: none;
}
.navbar .megamenu {
    margin: 0 6px 0 -6px;
}
li i{
    display: block;
    font-size: 23px;
    /*margin: 1px 0 0 218px;*/
}
.menu .cat-heading {
    display: flex;
    align-items: center;
    margin: 8px 0 0px 11px;
}
.menu {
    border-right: none;
}


.menu div ul
{
    display: none;
}
.menu div ul.open
{
    display: block;
}
.navbar-collapse
{
  min-height: 100vh;
  background-color: #f8f9fa!important;
}
.navbar-toggler:focus {
    box-shadow: none;
}



}


.dropdown-menu ul li
{
    padding: 0px !important;
}

.row.align-items-center.design-filter {
    max-height: 200px;
    overflow: auto;
    margin-top: 35px;
}
    
</style>



</head>

<body>
        <!-- Spinner Start -->
        <!-- <div id="spinner" class="show bg-white position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
            <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div> -->
        <!-- Spinner End -->


 <!-- Navbar Start -->
<div class="container-fluid nav-bar bg-transparent navigation p-0 ">
      <nav class=" navbar-expand-lg bg-white navbar-light py-2 px-0 px-md-3">
         <div class="menu-icon ">
            <span class="fas fa-bars bi bi-list"></span>
         </div>
         <div class="back-icon">
             <span><i class="fas fa-angle-left bi bi-chevron-left"></i></span>
         </div>
         <div class="logo">
             <a href="<?= site_url() ?>"> <img class="img-fluid" src="<?= SITE_MEDIA ?>front/img/logo-new.jpg" alt="Icon" style=""></a>
         </div>
         <div class="mx-auto">
             <div class="nav-items">

                <?php displayMenuItems(getMenuItem('HEADER-PRIMARY-MENU'));  ?>

          
    <?php if(isset($_SESSION['isUserLoggedIn'])){  

                    $cartQTy = count(getCartQty());

                    ?>
                <li>
                    <a href="<?= site_url('cart') ?>"  title="Quotation Cart"><span class="menu-cart" data-after="<?= $cartQTy ; ?>"><i class="bi bi-cart-check-fill fs-5"></i></span></a>
                </li>
                <?php } ?>
                
                <?php if(session()->get('isUserLoggedIn')){ ?>
                  


                    <li class="dropdown has-megamenu abc">
                        <a href="#" class="dropdown-toggle" data-bs-toggle="dropdown">Profile</a><div class="dropdown-menu small xyz" role="menu">
                            <a href="<?= site_url('user/dashboard') ?>" class="d-block py-2 px-2">Dashboard</a>
                            <a href="<?= site_url('user/quotation-history') ?>" class="d-block py-2 px-2">Quotation History</a>
                             <a href="<?= site_url('user/change-password') ?>" class="d-block py-2 px-2">Change Password</a>
                             <a href="<?= site_url('user/profile') ?>" class="d-block py-2 px-2">Update Profile</a>
                             <a href="<?= site_url('user/logout') ?>" class="d-block py-2 px-2">Logout</a>
                            
                        </div>
                    </li>




                <?php }else{ 
                
                    if(!isset($_SESSION['isUserLoggedIn'])){
                ?>
                    <li>
                        <a href="<?= site_url('user/login') ?>" title="Login">Login</a>
                    </li>
                <?php } } ?>



            
         </div>
         </div>
         <div class="search-icon">
            <span class="fas fa-search fw-bold bi bi-search"></span>
         </div>
         <div class="cancel-icon">
            <span class="fas fa-times "><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x-lg" viewBox="0 0 16 16">
  <path d="M2.146 2.854a.5.5 0 1 1 .708-.708L8 7.293l5.146-5.147a.5.5 0 0 1 .708.708L8.707 8l5.147 5.146a.5.5 0 0 1-.708.708L8 8.707l-5.146 5.147a.5.5 0 0 1-.708-.708L7.293 8 2.146 2.854Z"/>
</svg></span>
         </div>
         <form action="<?= site_url('search') ?>" align="right">
            <input type="search" class="search-data" name="q" placeholder="Search here" required>
            <button type="submit" class="fas fa-search bi bi-search res-search"></button>
         </form>
    </nav>






</div>

        <!-- Navbar End -->
<script type="text/javascript">
    

$(document).ready(function(){
    $('.cat-heading').click(function(){


        

        if($(this).parent().find('ul').hasClass('open'))
        {
            $(this).parent().find('ul').removeClass('open');
            $(this).find('.bi').addClass('bi-plus');
            $(this).find('.bi').removeClass('bi-dash');
        }else{
            $('.menu div ul').removeClass('open');
        $('.cat-heading').find('.bi').removeClass('bi-dash');
        $('.cat-heading').find('.bi').addClass('bi-plus');
            $(this).parent().find('ul').addClass('open');
            $(this).find('.bi').removeClass('bi-plus');
            $(this).find('.bi').addClass('bi-dash');
        }   
        


    })
})

</script>