<?php 
$uri = current_url(true); 
$sub_title = ucwords(str_replace('-',' ', $uri->getSegment(2)));

?>
<style>
	
	.post_multi_select .select2-container--default .select2-selection--multiple
	{
		min-height: 100px;
	}
	.accordion-button {
	    padding: 8px 10px;
	    font-size: 12px;
	}
	.accordion-body
	{
		padding: 10px 10px;
	}
	.accordion-button::after 
	{
	    width: 15px;
	    height: 15px;
	    background-size: 15px;
	}


	.file-upload {
  background-color: #ffffff;
  width: 100%;
  margin: 0 auto;
  padding: 0px;
}

.file-upload-btn {
  width: 100%;
  margin: 0;
  color: #fff;
  background: #1FB264;
  border: none;
  padding: 10px;
  border-radius: 4px;
  border-bottom: 4px solid #15824B;
  transition: all .2s ease;
  outline: none;
  text-transform: uppercase;
  font-weight: 700;
}

.file-upload-btn:hover {
  background: #1AA059;
  color: #ffffff;
  transition: all .2s ease;
  cursor: pointer;
}

.file-upload-btn:active {
  border: 0;
  transition: all .2s ease;
}

.file-upload-content {
  display: none;
  text-align: center;
}

.file-upload-input {
  position: absolute;
  margin: 0;
  padding: 0;
  width: 100%;
  height: 100%;
  outline: none;
  opacity: 0;
  cursor: pointer;
}

.image-upload-wrap {
  margin-top: 0px;
  border: 4px dashed #1FB264;
  position: relative;
}

.image-dropping,
.image-upload-wrap:hover {
  background-color: #1FB264;
  border: 4px dashed #ffffff;
  color: #fff;
}

.image-upload-wrap:hover .drag-text h3
{
	color: #fff;
}

.image-title-wrap {
  padding: 0 15px 15px 15px;
  color: #222;
}

.drag-text {
  text-align: center;
  padding: 10px;
}

.drag-text h3 {
  font-weight: 100;
  text-transform: uppercase;
  color: #15824B;
  padding: 30px 0;
  font-size: 11px;
}

.file-upload-image {
    max-height: 200px;
    max-width: 100%;
    margin: auto;
    margin-bottom: 10px;
    padding: 10px 0px;
}

.remove-image {
  width: 100%;
  margin: 0;
  color: #fff;
  background: #cd4535;
  border: none;
  padding: 8px;
  border-radius: 4px;
  border-bottom: 4px solid #b02818;
  transition: all .2s ease;
  outline: none;
  text-transform: uppercase;
  font-weight: 700;
}

.remove-image:hover {
  background: #c13b2a;
  color: #ffffff;
  transition: all .2s ease;
  cursor: pointer;
}

.remove-image:active {
  border: 0;
  transition: all .2s ease;
}


</style>

<script src="<?= site_url('ckeditor/ckeditor.js') ?>"></script>
<!-- <script src="https://cdn.ckeditor.com/4.19.0/standard/ckeditor.js"></script> -->
<!-- <script src="<?= site_url('lib/colorbutton/plugin.js'); ?>"></script> -->

<form action="<?= current_url().'?action=edit&token='.$_GET['token']; ?>" method="post" id='post_edit_form' enctype="multipart/form-data">

<div class="row bg-light p-3">
	<div class="col-md-12 pb-3">
		<div class="col-md-12 mb-3">
			<a href="<?= base_url($uri->getSegment(1).'/'.$uri->getSegment(2)) ?>" class="float-start btn btn-dark px-3 rounded-0 btn-sm"><?php echo $sub_title; ?> List</a>

			<span class="float-end">
				<button type="submit" class="btn btn-success rounded-0 btn-sm">Save</button>

				<button type="button" id="preview_btn" class="btn btn-warning rounded-0 btn-sm">Preview</button>

			</span>
		</div>
	</div>



	<div class="col-md-9">
		
		<div class="row ">
			<div class="col-md-12 mb-3">
				<label class="form-label">Title<sup class="text-danger fw-bold">*</sup></label>
				<input type="text" value="<?= $single_data['post_title']; ?>" class="form-control rounded-0" name="title" required>
			</div>
			
			
			<div class="col-md-12 mb-3">
				<label class="form-label">Content</label>
				<textarea name="description"  id="editor" class="form-control content_box rounded-0" ><?= $single_data['post_content']; ?></textarea>
			</div>
			
		</div>

	</div>




	<div class="col-md-3 pt-4">



<div class="accordion rounded-0" id="accordionExample">

  <div class="accordion-item">
    <h2 class="accordion-header" id="headingOne">
      <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
        Public Status
      </button>
    </h2>
    <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
      <div class="accordion-body">
        	<div class="mb-0">
				<select name="status" id="" class="form-select rounded-0">
					<?php 
						if($single_data['post_status'] == 'P')
						{
							echo '<option value="P" selected>Publish</option>
								  <option value="D">Draft</option>';
						}elseif($single_data['post_status'] == 'D')
						{
							echo '<option value="P">Publish</option>
								  <option value="D" selected>Draft</option>';
						}else
						{
							echo '<option value="P">Publish</option>
								  <option value="D" selected>Draft</option>';
						}
					 ?>
				</select>
			</div>
      </div>
    </div>
  </div>



  <div class="accordion-item">
    <h2 class="accordion-header" id="featured_image_heading">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#featured_image" aria-expanded="false" aria-controls="featured_image">
        Featured Image
      </button>
    </h2>
    <div id="featured_image" class="accordion-collapse collapse" aria-labelledby="featured_image_heading" data-bs-parent="#accordionExample">
      <div class="accordion-body">
        	<div class="mb-0 ">
				<div class="file-upload">
					  <!-- <button class="file-upload-btn" type="button" onclick="$('.file-upload-input').trigger( 'click' )">Add Image</button> -->

					  <div class="image-upload-wrap">
					    <input class="file-upload-input" id="file" name="file" type='file' onchange="readURL(this);" accept="image/*" />
					    <div class="drag-text">
					      <h3>Drag and drop a file or select add Image</h3>
					    </div>
					  </div>
					  <div class="file-upload-content">
					    <img class="file-upload-image" src="#" alt="your image" />
					    <div class="image-title-wrap">
					      <button type="button" onclick="removeUpload()" class="remove-image">Remove <span class="image-title">Uploaded Image</span></button>
					    </div>
					  </div>
					</div>
			</div>
      </div>
    </div>
  </div>


  <div class="accordion-item">
    <h2 class="accordion-header" id="headingTwo">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
        Slug
      </button>
    </h2>
    <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
      <div class="accordion-body">
        	<div class=" mb-0">
				<input type="text" value="<?= $single_data['post_slug']; ?>" class="form-control rounded-0" name="slug" >
			</div>
      </div>
    </div>
  </div>


  <div class="accordion-item">
    <h2 class="accordion-header" id="headingThree">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
        Category
      </button>
    </h2>
    <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
      <div class="accordion-body">
        	<div class="mb-0 post_multi_select">
				<select name="category[]" multiple class="form-select rounded-0" style=" width: 100%">
					<?php 
						$cat_array = explode(',', $single_data['post_categorys']);
						foreach ($cat_list as $row) {
							if(in_array($row['cat_id'], $cat_array))
							{
								echo '<option value="'.$row['cat_id'].'" selected>'.$row['cat_name'].'</option>';
							}else
							{
								echo '<option value="'.$row['cat_id'].'">'.$row['cat_name'].'</option>';
							}
						} 
					?>
				</select>
			</div>
      </div>
    </div>
  </div>

  <div class="accordion-item">
    <h2 class="accordion-header" id="heading4">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse4" aria-expanded="false" aria-controls="collapse4">
        Tags
      </button>
    </h2>
    <div id="collapse4" class="accordion-collapse collapse" aria-labelledby="heading4" data-bs-parent="#accordionExample">
      <div class="accordion-body">
        	<div class="mb-0 post_multi_select">
				<select name="tags[]" multiple class="form-select rounded-0" style="width: 100%">
					<?php 
						$tags_array = explode(',', $single_data['post_tags']);
						foreach ($tag_list as $row) {
							if(in_array($row['tag_id'], $tags_array))
							{
								echo '<option value="'.$row['tag_id'].'" selected >'.$row['tag_name'].'</option>';
							}else
							{
								echo '<option value="'.$row['tag_id'].'">'.$row['tag_name'].'</option>';
							}
						} 
					?>
				</select>
			</div>
      </div>
    </div>
  </div>

  <div class="accordion-item">
    <h2 class="accordion-header" id="heading5">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse5" aria-expanded="false" aria-controls="collapse5">
        Excerpt
      </button>
    </h2>
    <div id="collapse5" class="accordion-collapse collapse" aria-labelledby="heading5" data-bs-parent="#accordionExample">
      <div class="accordion-body">
        	<div class="mb-0 ">
				<textarea type="text" class="form-control rounded-0" name="excerpt" rows="4"><?= $single_data['post_excerpt'] ?></textarea>
			</div>
      </div>
    </div>
  </div>

  


</div>



	</div>
</div>
</form>


<script>
    CKEDITOR.replace( 'editor');
    CKEDITOR.config.extraPlugins = 'colorbutton';
</script>




<script>
	
<?php  if(!empty($single_data['post_featured_image'])){ ?>

$('.image-upload-wrap').hide();
const db_img = '<?= site_url('uploads/media/'.$single_data['post_featured_image']); ?>';
$('.file-upload-image').attr('src', db_img);
$('.file-upload-content').show();

<?php } ?>


function readURL(input) {
  if (input.files && input.files[0]) {

    var reader = new FileReader();

    reader.onload = function(e) {
      $('.image-upload-wrap').hide();
      $('.file-upload-image').attr('src', e.target.result);
      $('.file-upload-content').show();

      $('.image-title').html(input.files[0].name);

      	var form_data = new FormData();
      	form_data.append("file", document.getElementById('file').files[0]);

      	const imgInput = $('.file-upload-input').val();
      	const token = '<?= $_GET['token']; ?>'
        $.ajax({
            method:'POST',
            url: '<?= site_url('ajax/upload/post/featured_image?token='); ?>' + token,
            data:form_data,
            contentType: false,
		    cache: false,
		    processData: false,
            success:function(data){
                console.log(data);
            },
            error: function(data){
                console.log("error");
                console.log(data);
            }
        });
    };

    reader.readAsDataURL(input.files[0]);

  } else {
    removeUpload();
  }
}

function removeUpload() {
  $('.file-upload-input').replaceWith($('.file-upload-input').clone());
  $('.file-upload-content').hide();
  $('.image-upload-wrap').show();
}
$('.image-upload-wrap').bind('dragover', function () {
    $('.image-upload-wrap').addClass('image-dropping');
  });
  $('.image-upload-wrap').bind('dragleave', function () {
    $('.image-upload-wrap').removeClass('image-dropping');
});

</script>


<script>
	
$(document).ready(function(){
	$('#preview_btn').click(function(){
		const token = '<?= $_GET['token'] ?>';
		var content =  CKEDITOR.instances.editor.getData();
		$.ajax({
				url:'<?= site_url('ajax/update/post/preview/content') ?>',
				type:'POST',
				data:{token:token, content:content},
				success:function(data)
				{	
					console.log(data);
					next_url = '<?= site_url('preview/post?token='.$_GET['token']); ?>';
					window.open(next_url, "_blank");
				},
				error:function()
				{
					alert('error');
				}
			});
	});	
});

</script>
