<?php 
$uri = current_url(true); 
$sub_title = ucwords(str_replace('-',' ', $uri->getSegment(2)));

?>
<style>
	
	.post_multi_select .select2-container--default .select2-selection--multiple
	{
		min-height: 100px;
	}
	.accordion-button {
	    padding: 8px 10px;
	    font-size: 12px;
	}
	.accordion-body
	{
		padding: 10px 10px;
	}
	.accordion-button::after 
	{
	    width: 15px;
	    height: 15px;
	    background-size: 15px;
	}
</style>

<script src="https://cdn.ckeditor.com/4.19.0/standard/ckeditor.js"></script>


<form action="<?= current_url().'?action=create'; ?>" method="post">

<div class="row bg-light p-3">
	<div class="col-md-12 pb-3">
		<div class="col-md-12 mb-3">
			<a href="<?= base_url($uri->getSegment(1).'/'.$uri->getSegment(2)) ?>" class="float-start btn btn-dark px-3 rounded-0 btn-sm"><?php echo $sub_title; ?> List</a>

			<span class="float-end">
				<button type="submit" class="btn btn-success rounded-0 btn-sm">Save</button>
			</span>
		</div>
	</div>
	<div class="col-md-9">
		
		<div class="row ">
			<div class="col-md-12 mb-3">
				<label class="form-label">Title<sup class="text-danger fw-bold">*</sup></label>
				<input type="text" class="form-control rounded-0" name="title" required>
			</div>
			
			
			<div class="col-md-12 mb-3">
				<label class="form-label">Content</label>
				<textarea name="description"  id="editor" class="form-control rounded-0" ></textarea>
			</div>
			
		</div>

	</div>

	<div class="col-md-3 pt-4">



<div class="accordion rounded-0" id="accordionExample">

  <div class="accordion-item">
    <h2 class="accordion-header" id="headingOne">
      <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
        Public Status
      </button>
    </h2>
    <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
      <div class="accordion-body">
        	<div class="mb-0">
				<select name="status" id="" class="form-select rounded-0">
					<option value="P">Publish</option>
					<option value="D" selected>Draft</option>
				</select>
			</div>
      </div>
    </div>
  </div>


  <div class="accordion-item">
    <h2 class="accordion-header" id="headingTwo">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
        Slug
      </button>
    </h2>
    <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
      <div class="accordion-body">
        	<div class=" mb-0">
				<input type="text" class="form-control rounded-0" name="slug" >
			</div>
      </div>
    </div>
  </div>


  <div class="accordion-item">
    <h2 class="accordion-header" id="headingThree">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
        Category
      </button>
    </h2>
    <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
      <div class="accordion-body">
        	<div class="mb-0 post_multi_select">
				<select name="category[]" multiple class="form-select rounded-0" style=" width: 100%">
					<?php foreach ($cat_list as $row) {
						echo '<option value="'.$row['cat_id'].'">'.$row['cat_name'].'</option>';
					} ?>
				</select>
			</div>
      </div>
    </div>
  </div>

  <div class="accordion-item">
    <h2 class="accordion-header" id="heading4">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse4" aria-expanded="false" aria-controls="collapse4">
        Tags
      </button>
    </h2>
    <div id="collapse4" class="accordion-collapse collapse" aria-labelledby="heading4" data-bs-parent="#accordionExample">
      <div class="accordion-body">
        	<div class="mb-0 post_multi_select">
				<select name="tags[]" multiple class="form-select rounded-0" style="width: 100%">
					<?php foreach ($tag_list as $row) {
						echo '<option value="'.$row['tag_id'].'">'.$row['tag_name'].'</option>';
					} ?>
				</select>
			</div>
      </div>
    </div>
  </div>

  <div class="accordion-item">
    <h2 class="accordion-header" id="heading5">
      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse5" aria-expanded="false" aria-controls="collapse5">
        Excerpt
      </button>
    </h2>
    <div id="collapse5" class="accordion-collapse collapse" aria-labelledby="heading5" data-bs-parent="#accordionExample">
      <div class="accordion-body">
        	<div class="mb-0 ">
				<textarea type="text" class="form-control rounded-0" name="excerpt" rows="4"></textarea>
			</div>
      </div>
    </div>
  </div>


</div>



	</div>
</div>
</form>


<script>
    CKEDITOR.replace( 'editor' );
</script>