<?php 
$uri = current_url(true); 
$sub_title = ucwords(str_replace('-',' ', $uri->getSegment(2)));

?>


<div class="loader_outer">
	<div class="agoxn_ajax_loader"></div>	
</div>


<div class="row bg-light p-3">
	<div class="col-md-12 mt-3 mb-3">
		<h5>Image Slider</h5>
	</div>
	<div class="col-md-4 mb-3">
		<label class="form-label">Image Slider Group</label>
		<select name="status" id="image_slider_group" class="form-select rounded-0">
			<option value="">Select Image Group</option>
			<?php 
			foreach ($list as $row) {
				echo '<option value="'.$row['isg_code'].'">'.$row['isg_name'].'</option>';
			}
			 ?>
		</select>
	</div>



	<div class="col-md-12 py-4" id="slider_content">

	</div>
	
</div>

<script>

function readURL(input) {
  if (input.files && input.files[0]) {

    var reader = new FileReader();

    reader.onload = function(e) {
      $('.image-upload-wrap').hide();
      $('.file-upload-image').attr('src', e.target.result);
      $('.file-upload-content').show();

      $('.image-title').html(input.files[0].name);
    };

    reader.readAsDataURL(input.files[0]);

  } else {
    removeUpload();
  }
}

function removeUpload() {
  $('.file-upload-input').replaceWith($('.file-upload-input').clone());
  $('.file-upload-content').hide();
  $('.image-upload-wrap').show();
}
$('.image-upload-wrap').bind('dragover', function () {
    $('.image-upload-wrap').addClass('image-dropping');
  });
  $('.image-upload-wrap').bind('dragleave', function () {
    $('.image-upload-wrap').removeClass('image-dropping');
});

</script>

<script>
	
$(document).ready(function(){
	$('#image_slider_group').change(function(){
		const imgGroup = $(this).val();
		if(imgGroup)
		{
			// alert(imgGroup);
			console.warn(imgGroup);

			const ajax_url = '<?= current_url().'/get/silder_form?code='; ?>'
			// alert(ajax_url + imgGroup)
			$.ajax({
				url:ajax_url + imgGroup,
				type:'GET',
				beforeSend:function(){
			     	console.log('ajax request send');
			     	$('.loader_outer').css({'display':'block'});
			    },success:function(data){
			    	$('.loader_outer').css({'display':'none'});
			    	$('#slider_content').html('');
			    	$('#slider_content').html(data);
			    },error:function(){
			    	alert('AJAX REQUEST NOT SEND..');
			    }
			});


		}
	})
});

</script>