<?php 
$uri = current_url(true); 
$sub_title = ucwords(str_replace('-',' ', $uri->getSegment(2)));

?>

<form action="<?= current_url(); ?>" method="post">
<div class="row">
	<div class="col-md-12">
		<h4 class="fw-bold"><?= $sub_title.' '.ucfirst($uri->getSegment(3)); ?></h4>
	</div>
</div>


<div class="row bg-light p-3">
	<div class="col-md-12 mb-3">
		<a href="<?= base_url($uri->getSegment(1).'/'.$uri->getSegment(2)) ?>" class="float-end btn btn-primary rounded-0 btn-sm"><?php echo $sub_title; ?> List</a>
	</div>


	<div class="col-md-4 mb-3">
		<label class="form-label">First Name<sup class="text-danger fw-bold">*</sup></label>
		<input type="text" class="form-control rounded-0" name="fname" required>
	</div>
	<div class="col-md-4 mb-3">
		<label class="form-label">Middle Name</label>
		<input type="text" class="form-control rounded-0" name="mname" >
	</div>
	<div class="col-md-4 mb-3">
		<label class="form-label">Last Name<sup class="text-danger fw-bold">*</sup></label>
		<input type="text" class="form-control rounded-0" name="lname" required>
	</div>
	<div class="col-md-4 mb-3">
		<label class="form-label">Gender</label>
		<select name="gender" class="form-select rounded-0">
			<option value="">Select</option>
<?php 

if($genders)
{
	foreach ($genders as $row) { ?>
		
		<option value="<?= $row['gender_id'] ?>"><?= $row['gender_name'] ?></option>


	<?php }
} 

?>

		</select>
	</div>

	<div class="col-md-4 mb-3">
		<label class="form-label">Contact No.<sup class="text-danger fw-bold">*</sup></label>
		<input type="text" class="form-control rounded-0" name="contact_no" required>
	</div>
	<div class="col-md-4 mb-3">
		<label class="form-label">Alternate Contact No.</label>
		<input type="text" class="form-control rounded-0" name="alt_contact_no">
	</div>

	<div class="col-md-6 mb-3">
		<label class="form-label">Email<sup class="text-danger fw-bold">*</sup></label>
		<input type="email" class="form-control rounded-0" name="email" required>
	</div>
	<div class="col-md-6 mb-3">
		<label class="form-label">Alternate Email</label>
		<input type="email" class="form-control rounded-0" name="alt_email">
	</div>

	<div class="col-md-4 mb-3">
		<label class="form-label">Country<sup class="text-danger fw-bold">*</sup></label>
		<select name="country" class="form-select rounded-0" id="country" required>
			<option value="">Select</option>
				<?php 
				if($countrys)
				{
					foreach ($countrys as $row) { ?>	
						<option value="<?= $row['country_id'] ?>"><?= $row['country_name'] ?></option>
					<?php }
				} 
				?>
		</select>
	</div>

	<div class="col-md-4 mb-3">
		<label class="form-label">State<sup class="text-danger fw-bold">*</sup></label>
		<select name="state" id="ajax_state_list" class="form-select rounded-0" required>
						
		</select>
	</div>

	<div class="col-md-4 mb-3">
		<label class="form-label">City<sup class="text-danger fw-bold">*</sup></label>
		<select name="city" class="form-select rounded-0" id="ajax_city_list" required>
				
		</select>
	</div>


	<div class="col-md-8 mb-3">
		<label class="form-label">Street Address<sup class="text-danger fw-bold">*</sup></label>
		<input type="text" class="form-control rounded-0" name="street_address" required>
	</div>
	<div class="col-md-4 mb-3">
		<label class="form-label">Zip Code<sup class="text-danger fw-bold">*</sup></label>
		<input type="text" class="form-control rounded-0" name="zip_code" required>
	</div>

	<div class="col-md-6 mb-3">
		<label class="form-label">Latitude</label>
		<input type="text" class="form-control rounded-0" name="latitude" >
	</div>
	<div class="col-md-6 mb-3">
		<label class="form-label">Longitude</label>
		<input type="text" class="form-control rounded-0" name="longitude" >
	</div>
	<div class="col-md-6 mb-3">
		<label class="form-label">Password<sup class="text-danger fw-bold">*</sup></label>
		<input type="password" class="form-control rounded-0" name="password" required>
	</div>
	<div class="col-md-6 mb-3">
		<label class="form-label">Re-Type Password<sup class="text-danger fw-bold">*</sup></label>
		<input type="password" class="form-control rounded-0" name="re_type_password" required>
	</div>
	<div class="col-md-12 mb-3">
		<label class="form-label">Account Type</label>
		<select name="account_type" id="" class="form-select" required>
			<option value="">Select</option>
			
			<?php 
				if($at_list)
				{
					foreach ($at_list as $row) { ?>	
						<option value="<?= $row['at_id'] ?>"><?= $row['at_title'] ?></option>
					<?php }
				} 
			?>
		</select>
	</div>

	<div class="col-md-12">
		 <!-- id="form_submit_btn"  -->
		<button type="submit"class="btn btn-success rounded-0 btn-sm">Submit</button>
	</div>
</div>
</form>



<script>
	$(document).ready(function(){

		// Country Select And Display State
	    $('#country').change(function(){
	        const country_id = $(this).val();
	        $.ajax({
	            url:'<?= base_url('ajax/state/list?country_id='); ?>'+country_id,
	            type:'POST',
	            success:function(data)
	            {
	            	$('#ajax_state_list').html('');	
	            	$('#ajax_city_list').html('');
	            	$('#ajax_state_list').append(data);	            
	            }
	        });
	    });

	    // State Select And Display City
	    $('#ajax_state_list').change(function(){
	        const state_id = $(this).val();
	        $.ajax({
	            url:'<?= base_url('ajax/city/list?state_id='); ?>'+state_id,
	            type:'POST',
	            success:function(data)
	            {
	            	$('#ajax_city_list').html('');
	            	$('#ajax_city_list').append(data);	            
	            }
	        });
	    });


	});
</script>
