<?php 



##############################################################################################
// Get Home Page Data
if(!function_exists('getHomePage'))
{
    function getHomePage()
    {
        $db = \Config\Database::connect()->table('fe_home');
        $data = $db->where('home_id','1')->get()->getRow();
        return $data;
    }
}

##############################################################################################
// Get Menu Count By item ID
if(!function_exists('getMenuItem'))
{
    function getMenuItem($code)
    {
        $db = \Config\Database::connect()->table('fe_menu');
        $list = $db->where('fem_active','A')->where('fem_status', 'A')->orderby('fem_order', 'ASC')->where('fem_parent_item', '')->join('fe_menu_type','fem_parent_type = fe_menu_type.femt_id')->where('femt_code', $code)->where('femt_status', 'A')->get()->getResult();
        return $list;
    }
}


##############################################################################################
// Get Menu Count By item ID
if(!function_exists('getMenuItems'))
{
    function getMenuItems($items_id)
    {
        $db = \Config\Database::connect()->table('fe_menu');
        $list = $db->where('fem_active','A')->where('fem_status', 'A')->orderby('fem_order', 'ASC')->where('fem_parent_item', $items_id)->get()->getResult();
        

        displayMenuItems($list);

    }
}


##############################################################################################
// Get Menu Count By item ID
if(!function_exists('displayMenuItems'))
{
    function displayMenuItems($list)
    {

        foreach($list as $l){ 

            ($l->fem_open_new_tab == 'yes') ? $newTab = "target='_blank'" : $newTab = "" ;


            
            if(getMenuResultByItemid($l->fem_id))
            {
                echo "<li>";
                echo "<a href='#'>$l->fem_name</a>";
                echo "<ul>";
                getMenuItems($l->fem_id); 
                echo "</ul>";
                echo "</li>";
            }

            if($l->fem_item_type == 'mega-menu')
            {
                echo "<li class='dropdown has-megamenu abc'>";
                echo "<a href='#' class='dropdown-toggle'   data-bs-toggle='dropdown'>$l->fem_name</a>";
                $sectionData = getSectionById($l->fem_section_id);
                echo "<style>";
                echo $sectionData->section_content_css;
                echo "</style>";
                echo replace_section($sectionData->section_content_html);
                echo "<script>";
                echo $sectionData->section_content_js;
                echo "</script>";
                echo "</li>";
            }elseif($l->fem_item_type == 'page')
            {
                echo "<li>";
                
                $pageData = getPageDataById($l->fem_page_id);
                echo "<a href='".site_url($pageData->page_slug)."' $newTab >$l->fem_name</a>";
                echo "</li>";

            }elseif($l->fem_item_type == 'normal')
            {
                echo "<li>";
                echo "<a href='$l->fem_slug' $newTab >$l->fem_name</a>";
                echo "</li>";
            }


            

        }

    }
}


// Dynamic Replacer
if(!function_exists('replace_section'))
{
    function replace_section($message)
    {

        $replace_array = [
        'site_url' => site_url(),
        'site_name' => 'ABC XYZ',
        'sectionmenu'=> view('public/users/dashboard/productlist'),
        'message' => $message,
            ];

        

        function template($config){
            $newStr = $config['message'];
            foreach ($config as $key => $value) {
                $newStr = str_replace("%$key%", $value, $newStr);
            } 
            return $newStr; 
        }

        return template($replace_array);
    }
}



##############################################################################################
// Get Section Data By ID
if(!function_exists('getSectionById'))
{
    function getSectionById($id)
    {
        $db = \Config\Database::connect()->table('sections');
        $data = $db->where('section_active','A')->where('section_status', 'A')->where('section_id', $id)->get()->getRow();
        return $data;
    }
}


##############################################################################################
// Get Page Data By ID
if(!function_exists('getPageDataById'))
{
    function getPageDataById($id)
    {
        $db = \Config\Database::connect()->table('pages');
        $data = $db->where('page_active','A')->where('page_status', 'A')->where('page_id', $id)->get()->getRow();
        return $data;
    }
}




####################################    SECTIONS    ###########################################
// Get Section Data By Code
if(!function_exists('getSection'))
{
    function getSection($code)
    {
        $db = \Config\Database::connect()->table('sections');
        $data = $db->where('section_active','A')->where('section_status', 'A')->where('section_short_code', $code)->get()->getRow();
        return $data;
    }
}

// Display Sections

if(!function_exists('displaySection'))
{
    function displaySection($code)
    {
       $sectionData =  getSection($code);
       if(!empty($sectionData->section_content_css))
       {
            echo "<style>";
            echo $sectionData->section_content_css;
            echo "</style>";
       }
       echo $sectionData->section_content_html;
       if(!empty($sectionData->section_content_js))
       {
            echo "<script>";
            echo $sectionData->section_content_js;
            echo "</script>";
       }
    }
}



####################################    Social Links    ###########################################
// Get Social Links
if(!function_exists('getSocialLinks'))
{
    function getSocialLinks()
    {
        $db = \Config\Database::connect()->table('social_link');
        $data = $db->where('sl_status','P')->where('sl_active', 'A')->orderby('sl_order_by', 'ASC')->get()->getResult();
        return $data;
    }
}



// Get Social Links
if(!function_exists('displaySocialLinks'))
{
    function displaySocialLinks()
    {
        $list = getSocialLinks();

        foreach($list  as $l)
        {
            echo "<li>";
            echo "<a href='$l->sl_link' target='_blank'>$l->sl_name</a>";
            echo "</li>";
        }
    }
}

// Get Social Links
if(!function_exists('displaySocialIcons'))
{
    function displaySocialIcons()
    {
        $list = getSocialLinks();

        foreach($list  as $l)
        {
            echo "<li>";
            echo "<a href='$l->sl_link' target='_blank'><i class='$l->sl_icon'></i></a>";
            echo "</li>";
        }
    }
}



####################################    Site Data    ###########################################

// Get Site  Info
if(!function_exists('getSiteData'))
{
    function getSiteData()
    {
        $db = \Config\Database::connect()->table('site_info');
        $data = $db->where('site_id', '1')->get()->getRow();
        return $data;
    }
}

// Display Site  Info
if(!function_exists('displaySiteData'))
{
    function displaySiteData($key)
    {
        $data = getSiteData();
        $key_array = [
                        'SITE_TITLE' => $data->site_title,
                        'SITE_TAG_LINE' => $data->site_tag_line,
                        'SITE_DESCRIPTION' => $data->site_description,
                        'SITE_PRIMARY_EMAIL' => $data->site_primary_email,
                        'SITE_SECONDARY_EMAIL' => $data->site_secondary_email,
                        'SITE_COPYRIGHT' => $data->site_copyright,
                        'SITE_LOGO' => $data->site_logo,
                        'SITE_FAVICON' => $data->site_favicon,
                        'SITE_PRIMARY_CONTACT_NO' => $data->site_primary_contact_no,
                        'SITE_SECONDARY_CONTACT_NO' => $data->site_secondary_contact_no,
                        'SITE_PRIMARY_ADDRESS' => $data->site_primary_address,
                        'SITE_SECONDARY_ADDRESS' => $data->site_secondary_address,
                        'SITE_HEADER_TAGS' => $data->site_header_content,
                        'SITE_FOOTER_TAGS' => $data->site_footer_content,
                    ];
                    
        echo $key_array[$key];
    }
}



##############################################################################################
// Display Page By Id
if(!function_exists('displayPageDataByID'))
{
    function displayPageDataByID($id)
    {
        $db = \Config\Database::connect()->table('pages');
        $data = $db->where('page_id',$id)->where('page_status', 'A')->where('page_active', 'A')->get()->getRow();
        echo $data->page_content;
    }
}


##############################################################################################
// Get Testimonial Data
if(!function_exists('getTestimonials'))
{
    function getTestimonials()
    {
       $db = \Config\Database::connect()->table('testimonials');
       return $db->where('tstmnl_active','A')->where('tstmnl_status','A')->orderby('tstmnl_order', 'ASC')->get()->getResult();
    }
}



##############################################################################################
// Get Product Shades
if(!function_exists('getProductShades'))
{
    function getProductShades($ids)
    {

        $array = explode(',', $ids);

       $db = \Config\Database::connect()->table('cwf_color_shades');
       return $db->where('cwfc_status','A')->where('cwfc_active','A')->whereIn('cwfc_id',$array)->orderby('cwfc_order', 'ASC')->get()->getResult();
    }
}



##############################################################################################
// Get Product Shades
if(!function_exists('getLoginUserData'))
{
    function getLoginUserData()
    {
        $db = \Config\Database::connect()->table('admin_accounts');
        return $db->where('ac_id', $_SESSION['isUserLoggedIn']['user_id'])->get()->getRow();
    }
}

