<?php 


##############################################################################################
// Get Sub Category List By Category ID 
if (!function_exists("getCwfCategoryListByID")) {
    function getCwfCategoryListByID($parent_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('cwf_category');
        $query   = $builder->where('cwf_cat_parent_id',$parent_id)->orderby('cwf_cat_order', 'ASC')->where('cwf_cat_active', 'A')->get();
        return $query   = $query->getResult();
    }
}


##############################################################################################
// Get Sub Category List By Category ID Child
if (!function_exists("getCwfCategoryListByIDChild")) {
    function getCwfCategoryListByIDChild($parent_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('cwf_category');
        $query   = $builder->where('cwf_cat_parent_id',$parent_id)->select('cwf_cat_id, cwf_cat_parent_id, cwf_cat_name')->orderby('cwf_cat_order', 'ASC')->where('cwf_cat_active', 'A')->get();
        return $query   = $query->getResult();
    }
}


// Get Category Dropdown

if (!function_exists("getCategoryOptions")) {
    function getCategoryOptions($select_id = null)
    {
        $db      = \Config\Database::connect()->table('cwf_category');
        $data = $db->where('cwf_cat_active','A')->select('cwf_cat_id, cwf_cat_parent_id, cwf_cat_name')->orderby('cwf_cat_order', 'ASC')->where('cwf_cat_parent_id', Null)->get()->getResult();

        displayCategoryOptions($data, 0, $select_id);
    }
}

if (!function_exists("displayCategoryOptions")) {
    function displayCategoryOptions($data, $level, $select_id)
    {
        $space = '';
        for ($i=0; $i < $level; $i++) { 
            $space .= "&nbsp;";
        }

        foreach($data as $row)
        {
            // echo "<pre>";
            // print_r($row);

            if($select_id == $row->cwf_cat_id)
            {
                echo '<option value="'.$row->cwf_cat_id.'" selected>'.$space.$row->cwf_cat_name.'</option>';
            }else
            {
                echo '<option value="'.$row->cwf_cat_id.'">'.$space.$row->cwf_cat_name.'</option>';
            }
                

            // $subcat = getCwfCategoryListByIDChild($row->cwf_cat_id);
            // displayCategoryOptions($subcat, $level+5, $select_id);

            // echo "</pre>";
        }

    }
}


##############################################################################################
// Get Sub Category List By Category ID 
if (!function_exists("getProductHash")) {
    function getProductHash($product_Id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('cwf_products');
        $query   = $builder->where('pro_id',$product_Id)->get();
        $query   = $query->getRow();

        return $query->pro_hash;
    }
}







##############################################################################################
// GET Product Image By ID
if (!function_exists("getProductImageByID")) {
    function getProductImageByID($img_id)
    {
        $db = dbconnect('cwf_prod_images');
        return $db->where('cwfpi_id', $img_id)->where('cwfpi_active', 'A')->where('cwfpi_status', 'A')->get()->getRow();
    }
}
##############################################################################################
// GET Product Color By ID
if (!function_exists("getProductColorByID")) {
    function getProductColorByID($color_id)
    {
        $db = dbconnect('cwf_prod_color'); 
        return $db->where('cwfpc_active','A')->where('cwfpc_status','A')->where('cwfpc_id', $color_id)->orderby('cwfpc_order', 'ASC')->join('cwf_color', 'cwfpc_color_id = cwf_color.cwfc_id')->get()->getRow();
    }
}






// Get Product  Count With Color 

if (!function_exists("getColorProduct")) {
    function getColorProduct($data)
    {
        $cat_id = $data['cat_id'];
        $color_id = $data['color_id'];


        $db = dbconnect('cwf_products');
            $db->select('pro_id')->distinct();
            $db->whereNotIn('pro_low_price', [0])->like('pro_shades', $color_id);
        // return $db->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->where('cwf_cat_parent_id', $cat_id)->where('pro_active', 'A')->where('pro_status', 'A')->get()->getResult();
        return  $db->where('pro_category', $cat_id)->where('pro_status', 'A')->get()->getResult();


    }
}









##############################################################################################
// Get Filter Sub Options
if (!function_exists("getFilterCild")) {
    function getFilterCild($parent_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('cwf_filters_value');
        $query   = $builder->where('cwf_fltrvlu_fltr_id',$parent_id)->orderby('cwf_fltrvlu_order', 'ASC')->where('cwf_fltrvlu_status', 'A')->where('cwf_fltrvlu_active', 'A')->get();
        return $query   = $query->getResult();
    }
}







// FILTER HELPER

if (!function_exists("getFilter")) {
    function getFilter()
    {
        return $_SESSION['filter'];
    }
}

// GET PRODUCT CATEGORY

if (!function_exists("getProductCategory")) {
    function getProductCategory($pro_id)
    {
        $db = \Config\Database::connect()->table('cwf_products');
        $pro_details =  $db->where('pro_active  ','A')->where('pro_id', $pro_id)->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->get()->getRow();

        $db = dbconnect('cwf_category');
        return $db->where('cwf_cat_id', $pro_details->cwf_cat_parent_id)->where('cwf_cat_status', 'A')->where('cwf_cat_active', 'A')->get()->getRow();
    }
}


if (!function_exists("getProductSubCategory")) {
    function getProductSubCategory($pro_id)
    {
        $db = \Config\Database::connect()->table('cwf_products');
        return  $db->where('pro_active  ','A')->where('pro_id', $pro_id)->join('cwf_category', 'pro_category = cwf_category.cwf_cat_id')->get()->getRow();
    }
}

// Get Brand Info

if (!function_exists("getBrandByID")) {
    function getBrandByID($id)
    {
        $db = dbconnect('cwf_brand');
        return $db->where('cwfb_active','A')->where('cwfb_status','A')->where('cwfb_id', $id)->get()->getRow();
    }
}


// Currency Formater

if(!function_exists('currency_filter'))
{
    function currency_filter($number)
    {
        return sprintf("%1\$.2f",$number);
    }
}




// Get Category Images

if (!function_exists("getCategoryBannerImages")) {
    function getCategoryBannerImages($id)
    {
        $db = dbconnect('cwf_cat_banner_images');
        return $db->where('cwfcbi_active','A')->where('cwfcbi_status','A')->where('cwfcbi_cat_id', $id)->get()->getResult();
    }
}



// Get Category Images

if (!function_exists("getCategoryProductBannerImages")) {
    function getCategoryProductBannerImages($id)
    {
        $db = dbconnect('cwf_pro_banner_images');
        return $db->where('cwfpbi_active','A')->where('cwfpbi_status','A')->where('cwfpbi_pro_id', $id)->get()->getResult();
    }
}




// Get Cart QTY

if (!function_exists("getCartQty")) {
    function getCartQty()
    {
        $db = dbconnect('cart_items');
        $total_items_incart = $db->where('ci_cust_id', dsession_id())->join('cwf_products', 'ci_prod_id = cwf_products.pro_id')->where('ci_active', 'A')->where('ci_expiry_status', 'A')->get()->getResult();

        return $total_items_incart;
    }
}



##############################################################################################
// GET Product Color By ID
if (!function_exists("getProductImageBySKUID")) {
    function getProductImageBySKUID($sku_code)
    {
        $db = dbconnect('cwf_pro_sku'); 
        return $db->where('cwf_psku_status','A')->where('cwf_psku_active','A')->where('cwf_psku_code', $sku_code)->join('cwf_prod_images', 'cwf_psku_color_id = cwf_prod_images.cwfpi_color')->get()->getRow();
    }
}

##############################################################################################
// GET Product Color By ID
if (!function_exists("getUnitsInfo")) {
    function getUnitsInfo($id)
    {
        $db = dbconnect('cwf_units'); 
        return $db->where('cwf_units_active','1')->where('cwf_units_status','A')->where('cwf_units_id', $id)->get()->getRow();
    }
}


##############################################################################################
// GET Product Color By ID
if (!function_exists("getUnitsList")) {
    function getUnitsList()
    {
        $db = dbconnect('cwf_units'); 
        return $db->where('cwf_units_active','1')->where('cwf_units_status','A')->get()->getResult();
    }
}



// GET Product Color By ID
if (!function_exists("calculateSum")) {
    function calculateSum($v1,$v2)
    {
        return $v1 + $v2;
    }
}




// GET Product Color By ID
if (!function_exists("checkInvoiceCreated")) {
    function checkInvoiceCreated($order_id)
    {
        $db = dbconnect('cwf_invoice');
        return $db->where('cwf_inv_order_id', $order_id)->get()->getRow();
    }
}






// GET Product Color By ID
if (!function_exists("cartCalData")) {
    function cartCalData($item_id)
    {
        $db = dbconnect('calculateData');
        return $db->where('cd_order_item_id', $item_id)->get()->getResult();
    }
}


// GET Product Color By ID
if (!function_exists("getLowestPriceDataByProID")) {
    function getLowestPriceDataByProID($pro_id)
    {
        $db = dbconnect('cwf_pro_variant');
        $price_list = $db->where('cwf_pv_product_id', $pro_id)->where('cwf_pv_active', 'A')->where('cwf_pv_status', 'A')->get()->getResult();
            
        
    

        $priceArray = [];

        foreach($price_list as $pl)
        {   
            array_push($priceArray, (float)$pl->cwf_pv_price);
        }

        if($priceArray)
        {
            return min($priceArray);
        }
        return 0;
        

    }
}





// Update Product Price
if (!function_exists("updateLowestPrice")) {
    function updateLowestPrice($pro_id)
    {
        $db = dbconnect('cwf_products');
        $upData = [
                            'pro_low_price' => getLowestPriceDataByProID($pro_id),
                        ];
        $db->where('pro_id', $pro_id)->set($upData)->update();
    }
}



// Update Product Price
if (!function_exists("imgOptimize")) {
    function imgOptimize($url)
    {
        $percent = 50;
                            
                                // Content type
                                header('Content-Type: image/jpeg');
                            
                                $data = base64_decode($img);
                                $im = imagecreatefromstring($data);
                                $width = imagesx($im);
                                $height = imagesy($im);
                                $newwidth = $width * $percent;
                                $newheight = $height * $percent;
                            
                                $thumb = imagecreatetruecolor($newwidth, $newheight);
                            
                                // Resize
                                imagecopyresized($thumb, $im, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
                            
                                // Output
                               return imagejpeg($thumb);
    }
}









// GET Product data by id
if (!function_exists("getProductDataByAccessID")) {
    function getProductDataByAccessID($id)
    {
        $db = dbconnect('cwf_prod_accessories');

        return  $db->where('cwfpa_id', $id)->join('cwf_products', 'cwf_products.pro_id = cwfpa_product_id')->get()->getRow();
    }
}

// GET SKU Code data by ids
if (!function_exists("getProductSkuDataByIds")) {
    function getProductSkuDataByIds($ids)
    {

        $idarray = explode(',', $ids);

        $db = dbconnect('cwf_pro_sku');
        return $db->whereIn('cwf_psku_id',$idarray)->where('cwf_psku_active', 'A')->where('cwf_psku_status', 'A')->join('cwf_prod_color', 'cwf_psku_color_id = cwf_prod_color.cwfpc_id')->join('cwf_color', 'cwfpc_color_id = cwf_color.cwfc_id')->orderby('cwf_psku_order', 'ASC')->get()->getResult();
    }
}


// GET Product data by id
if (!function_exists("getVartientData")) {
    function getVartientData($id)
    {
        $db = dbconnect('cwf_pro_variant');

        return  $db->where('cwf_pv_id', $id)->join('carpet_width', 'carpet_width.cw_id = cwf_pv_width_id')->get()->getRow();
    }
}

