<?php

namespace App\Controllers;
use App\Models\StateModel;
use App\Models\CityModel;

class UserDashboard extends BaseController
{
    public function index()
    {    
        $userData = getLoginUserData();

        $genders = dbconnect('gender');
        $data['genders'] = $genders->orderBy('gender_name', 'ASC')->where('gender_active','A')->where('gender_status','A')->get()->getResult();
        $countrys = dbconnect('country');
        $data['countrys'] = $countrys->orderBy('country_name', 'ASC')->where('country_status', 'A')->where('country_active','A')->get()->getResult();


        $states = new StateModel();
        if(!empty($userData->ac_country))
        {
            $data['state'] = $states->orderBy('state_title', 'ASC')->where(['state_active'=>'A', 'state_status' => 'A', 'sate_country_id'=>$userData->ac_country])->findAll();
        }else
        {
            $data['state'] = $states->orderBy('state_title', 'ASC')->where(['state_active'=>'A', 'state_status' => 'A'])->findAll();
        }

        $citys = new CityModel();
        if(!empty($userData->ac_state))
        {
            $data['citys'] = $citys->orderBy('city_name', 'ASC')->where(['city_active'=>'A', 'city_status' => 'A', 'city_state_id'=>$userData->ac_state])->findAll();
        }else
        {
            $data['citys'] = $citys->orderBy('city_name', 'ASC')->where(['city_active'=>'A', 'city_status' => 'A'])->findAll();
        }
        
        $db = dbconnect('order');
        $data['order_list'] = $db->orderby('o_id', 'DESC')->where('o_cust_id', dsession_id())->get()->getResult();

		echo view('public/users/dashboard/index', $data);
    }

    public function quotation_history()
    {
        $db = dbconnect('order');
        $data['order_list'] = $db->orderby('o_id', 'DESC')->where('o_cust_id', dsession_id())->get()->getResult();
        echo view('public/users/dashboard/quotation-history', $data);
    }

    public function completeProfileView()
    {
        $userData = getLoginUserData();

        $genders = dbconnect('gender');
        $data['genders'] = $genders->orderBy('gender_name', 'ASC')->where('gender_active','A')->where('gender_status','A')->get()->getResult();
        $countrys = dbconnect('country');
        $data['countrys'] = $countrys->orderBy('country_name', 'ASC')->where('country_status', 'A')->where('country_active','A')->get()->getResult();


        $states = new StateModel();
        if(!empty($userData->ac_country))
        {
            $data['state'] = $states->orderBy('state_title', 'ASC')->where(['state_active'=>'A', 'state_status' => 'A', 'sate_country_id'=>$userData->ac_country])->findAll();
        }else
        {
            $data['state'] = $states->orderBy('state_title', 'ASC')->where(['state_active'=>'A', 'state_status' => 'A'])->findAll();
        }

        $citys = new CityModel();
        if(!empty($userData->ac_state))
        {
            $data['citys'] = $citys->orderBy('city_name', 'ASC')->where(['city_active'=>'A', 'city_status' => 'A', 'city_state_id'=>$userData->ac_state])->findAll();
        }else
        {
            $data['citys'] = $citys->orderBy('city_name', 'ASC')->where(['city_active'=>'A', 'city_status' => 'A'])->findAll();
        }
        
        

        echo view('public/users/dashboard/profile', $data);
    }
    
    
      public function orderDetails()
    {
        $token = $_GET['token'];

        $db = \Config\Database::connect()->table('order');
        $data['details'] =  $db->where('o_hash', $token)->get()->getRow();

        $db = dbconnect('order_cart_items');
        $data['list'] = $db->where('oci_order_id', $data['details']->o_id)->join('cwf_products', 'oci_prod_id = cwf_products.pro_id')->get()->getResult();

        echo view('public/users/order/details', $data);
    }


    public function completeProfile()
    {
        $data = $this->request->getVar();
        $db = \Config\Database::connect()->table('admin_accounts');

        $updateData = [
                            'ac_street_address' => ltrim($data['full_address']),
                            'ac_zip' => ltrim($data['zip']),
                            'ac_gender' => $data['gender'],
                            'ac_city' => $data['city'],
                            'ac_state' => $data['state'],
                            'ac_country' => $data['country']
                        ];
        if($db->where('ac_id', $_SESSION['isUserLoggedIn']['user_id'])->set($updateData)->update())
        {
            session()->setFlashdata("success", "Profile Data Updated!");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Profile Data Not Updated!");
            return $this->response->redirect(current_url());
        }
    }
   



    public function changePassword()
    {
         echo view('public/users/dashboard/password_change');
    }


    public function changePasswordPost()
    {
        $data = $this->request->getVar();

        $db = dbconnect('admin_accounts');
        $profile_data = $db->where('ac_id', dsession_id())->where('ac_password', md5($data['current_password']))->get()->getRow();

        // echo "<pre>";
        // print_r($data);
        // echo "</pre>";


        if($profile_data)
        {
            if($data['new_password'] === $data['repassword'])
            {
                $updated_data = [
                                    'ac_password' => md5($data['new_password'])
                                ];
                if($db->where('ac_id', dsession_id())->set($updated_data)->update())
                {
                    session()->setFlashdata("success", "Password Changed...");
                    return $this->response->redirect(current_url());
                }else
                {
                    session()->setFlashdata("error", "Password Not Changed!");
                    return $this->response->redirect(current_url());
                }
            }else
            {
                // Password and retype password not matched
                session()->setFlashdata("error", "Password and retype password not matched!");
                return $this->response->redirect(current_url());
            }
        }else
        {
            // Please Enter Current Password
            session()->setFlashdata("error", "Current Password Not Valid!");
            return $this->response->redirect(current_url());
        }

    }





}
