<?php 
namespace App\Controllers\Cwf;
use App\Controllers\BaseController;

class VouchersController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $db = \Config\Database::connect()->table('vouchers');
        $data['list'] = $db->where('vchr_active','A')->orderby('vchr_order', 'ASC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Cwf/vouchers/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        echo view('Admin/include/header');
        echo view('Cwf/vouchers/add');
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {

        // echo "<pre>";
        // print_r($data);
        // echo "</pre>";

        // exit();

        $db = \Config\Database::connect()->table('vouchers');

           
            $results = $db->where('vchr_name', $data['code'])->where('vchr_active','A')->get()->getResult();
            $results_count = $db->get()->getResult();

            if($results)
            {
                session()->setFlashdata("error", "Data Not Unique");
                return $this->response->redirect(current_url());
            }

            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
            }

        $save_data = array(
                            'vchr_hash'=> createHash(),
                            'vchr_name'=> $data['name'],
                            'vchr_code'=> $data['code'],
                            'vchr_description'=> $data['description'],
                            'vchr_uses_per_coupons'=> $data['uses_per_coupons'],
                            'vchr_discount_apply'=> $data['discount_apply'],
                            'vchr_discount_amount'=> $data['discount_amount'],
                            'vchr_max_discount_amount'=> $data['max_discount_amount'],
                            'vchr_uses_per_customer'=> $data['uses_per_customer'],
                            'vchr_minimum_cart_value'=> $data['minimum_cart_value'],
                            'vchr_started_at'=> $data['started_at'],
                            'vchr_expires_at'=> $data['expires_at'],
                            'vchr_order' => count($results_count) + 1 ,
                            'vchr_status' => $data['status'],
                            'vchr_active' => 'A',
                            'vchr_created_ip' => $this->request->getIPAddress(),
                            'vchr_created_id' => dsession_id(),
                            'vchr_updated_ip'  => $this->request->getIPAddress(),
                            'vchr_updated_id' => dsession_id(),
                            'vchr_updated_at' => date("Y-m-d h:i:s"),
                        );

       
        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $db = \Config\Database::connect()->table('vouchers');
        $data['cat_data'] = (array) $db->where('vchr_active','A')->where('vchr_hash', $token)->get()->getRow();
        echo view('Admin/include/header');
        echo view('Cwf/vouchers/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('vouchers');


        $save_data = array(
                            'vchr_name'=> $data['title'],
                            'vchr_code'=> $data['code'],
                            'vchr_description'=> $data['description'],
                            'vchr_uses_per_coupons'=> $data['uses_per_coupons'],
                            'vchr_discount_apply'=> $data['discount_apply'],
                            'vchr_discount_amount'=> $data['discount_amount'],
                            'vchr_max_discount_amount'=> $data['max_discount_amount'],
                            'vchr_uses_per_customer'=> $data['uses_per_customer'],
                            'vchr_minimum_cart_value'=> $data['minimum_cart_value'],
                            'vchr_started_at'=> $data['started_at'],
                            'vchr_expires_at'=> $data['expires_at'],
                            'vchr_status' => $data['status'],
                            'vchr_updated_ip'  => $this->request->getIPAddress(),
                            'vchr_updated_id' => dsession_id(),
                            'vchr_updated_at' => date("Y-m-d h:i:s"),
                        );
        

        if($db->where('vchr_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}

