<?php 
namespace App\Controllers\Cwf;
use App\Models\CountryModel;
use App\Models\AccountModel;
use App\Controllers\BaseController;

class SupplierPortalController extends BaseController
{   
   
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }elseif($action == 'remove')
            {
                $this->remove();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else{
            $this->list();
        }
    }

    // LIST
    public function list()
    {
         $supplier_id = $this->request->getGet('supplier_id');
        $db = \Config\Database::connect()->table('cwf_supplier_portals');
        $data['list'] = $db->where("supplier_id",$supplier_id)->get()->getResult();
         $data['supplier_id'] = $supplier_id;
    


        echo view('Admin/include/header');
        echo view('Cwf/supplier_portal/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        $countrys = new CountryModel();
        $dyanmicData['countrys'] = $countrys->orderBy('country_name', 'ASC')->where('country_active','A')->findAll();
        $supplier_id = $this->request->getGet('supplier_id');
        $dyanmicData['supplier_id'] = $supplier_id;
 // print_r($dyanmicData);exit;
        echo view('Admin/include/header');
        echo view('Cwf/supplier_portal/add', $dyanmicData);
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
       
      
            $sup_db = \Config\Database::connect()->table('cwf_supplier_portals');
            $current_time = getdate();
            $supplier_table = [
                                'sup_hash' => createHash(),
                                'supplier_id' => $data['supplier_id'],
                                'title' => $data['title'],
                                'url' => $data['url'],
                            ];

            if($sup_db->insert($supplier_table))
            {
                session()->setFlashdata("success", "Opration SuccessFul");
                return $this->response->redirect(current_url().'?supplier_id='.$data['supplier_id']);
            }else
            {
                session()->setFlashdata("error", "Opration Not Complete");
                return $this->response->redirect(current_url().'?supplier_id='.$data['supplier_id']);
            }
            
      
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $countrys = new CountryModel();
        $data['countrys'] = $countrys->orderBy('country_name', 'ASC')->where('country_active','A')->findAll();

        $db = \Config\Database::connect()->table('cwf_supplier_portals');
        $data['details'] = $db->where('sup_hash', $token)->get()->getRow();


        echo view('Admin/include/header');
        echo view('Cwf/supplier_portal/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        // $db = \Config\Database::connect()->table('admin_accounts');

      
            $sup_db = \Config\Database::connect()->table('cwf_supplier_portals');
    
            $supplier_table = [
                             
                                'supplier_id' => $data['supplier_id'],
                                'title' => $data['title'],
                                'url' => $data['url'],
                            ];

            if($sup_db->where('sup_id', $data['account_id'])->set($supplier_table)->update())
            {
                session()->setFlashdata("success", "Opration SuccessFul");
                return $this->response->redirect(current_url().'?supplier_id='.$data['supplier_id']);
            }else
            {
                session()->setFlashdata("error", "Opration Not Complete");
                return $this->response->redirect(current_url().'?supplier_id='.$data['supplier_id']);
            }
            
       

    }


    public function remove()
    {
        $db = \Config\Database::connect()->table('cwf_supplier_portals');
         $supplier_id = $this->request->getGet('supplier_id');
      
        // $save_data = array(
        //                     'ac_active' => 'D',
        //                     'ac_updated_ip'  => $this->request->getIPAddress(),
        //                     'ac_updated_id' => dsession_id(),
        //                     'ac_updated_at' => date("Y-m-d h:i:s"),
        //                 );
        
       
        if($db->where('sup_hash', $_GET['token'])->where('sup_id', $_GET['sup_id'])->where('supplier_id', $supplier_id)->delete())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
                return $this->response->redirect(current_url().'?supplier_id='.$supplier_id);
            
        }else{
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url().'?supplier_id='.$supplier_id);
        }

    }

}

