<?php 
namespace App\Controllers\Cwf;
use App\Models\CountryModel;
use App\Models\AccountModel;
use App\Controllers\BaseController;

class SupplierController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }elseif($action == 'remove')
            {
                $this->remove();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $db = \Config\Database::connect()->table('cwf_suppliers');
        $data['list'] = $db->join('admin_accounts', 'sup_ac_id = admin_accounts.ac_id')->where('ac_active','A')->join('account_type', 'ac_type = account_type.at_id')->where('at_code', 'S')->get()->getResult();

      


        echo view('Admin/include/header');
        echo view('Cwf/supplier/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        $countrys = new CountryModel();
        $dyanmicData['countrys'] = $countrys->orderBy('country_name', 'ASC')->where('country_active','A')->findAll();
        echo view('Admin/include/header');
        echo view('Cwf/supplier/add', $dyanmicData);
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        // echo "<pre>";
        // print_r($data);
        // echo "</pre>";

        // $db = \Config\Database::connect()->table('admin_accounts');
        $db = new AccountModel();

        $results = $db->where('ac_email', $data['email'])->get()->getResult();
        $results_count = $db->get()->getResult();

        if($results)
        {
            session()->setFlashdata("error", "Email Already Used!");
            return $this->response->redirect(current_url());
        }

        $save_data = array(
                            'ac_fname'=> $data['first_name'],
                            'ac_lname'=> $data['last_name'],
                            'ac_email'=> $data['email'],
                            'ac_contact_no'=> $data['contact_no'],
                            'ac_status' => $data['status'],
                            'ac_active' => 'A',
                            'ac_type' => '4',
                            'ac_created_at' => date("Y-m-d h:i:s"),
                            'ac_password' => md5(rand(100000,99999999)),
                            'ac_created_ip' => $this->request->getIPAddress(),
                            'ac_created_id' => dsession_id(),
                            'ac_updated_ip'  => $this->request->getIPAddress(),
                            'ac_updated_id' => dsession_id(),
                            'ac_updated_at' => date("Y-m-d h:i:s"),
                        );

        // echo "<pre>";
        // print_r($save_data);
        // echo "<pre>";

            

        // echo "<pre>";
        // print_r($supplier_table);

        // exit();       

        if($db->insert($save_data))
        {

            $sup_db = \Config\Database::connect()->table('cwf_suppliers');
            $current_time = getdate();
            $supplier_table = [
                                'sup_hash' => createHash(),
                                'sup_ac_id' => $db->getInsertID(),
                                'sup_company' => $data['company_name'],
                                'sup_address1' => $data['address1'],
                                'sup_address2' => $data['address2'],
                                'sup_city' => $data['city'],
                                'sup_zip_code' => $data['zip_code'],
                                'sup_country' => $data['country'],
                                'sup_sales_dprt_email' => $data['sales_dprt_email'],
                                'sup_telephone_no' => $data['telephone_no'],
                                'sup_tax_id' => $data['tax_id'],
                                'sup_ref_no' => $data['ref_id'],
                                'sup_code' => 'CWFS'.$current_time['0'],
                            ];

            if($sup_db->insert($supplier_table))
            {
                session()->setFlashdata("success", "Opration SuccessFul");
                return $this->response->redirect(current_url());
            }else
            {
                session()->setFlashdata("error", "Opration Not Complete");
                return $this->response->redirect(current_url());
            }
            
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $countrys = new CountryModel();
        $data['countrys'] = $countrys->orderBy('country_name', 'ASC')->where('country_active','A')->findAll();

        $db = \Config\Database::connect()->table('cwf_suppliers');
        $data['details'] = $db->where('sup_hash', $token)->join('admin_accounts', 'sup_ac_id = admin_accounts.ac_id')->where('ac_active','A')->join('account_type', 'ac_type = account_type.at_id')->where('at_code', 'S')->get()->getRow();

        // echo "<pre>";
        // print_r($data['details']);
        // exit();

        echo view('Admin/include/header');
        echo view('Cwf/supplier/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('admin_accounts');

        $save_data = array(
                            'ac_fname'=> $data['first_name'],
                            'ac_lname'=> $data['last_name'],
                            'ac_email'=> $data['email'],
                            'ac_contact_no'=> $data['contact_no'],
                            'ac_status' => $data['status'],
                            'ac_updated_ip'  => $this->request->getIPAddress(),
                            'ac_updated_id' => dsession_id(),
                            'ac_updated_at' => date("Y-m-d h:i:s"),
                        );
        

        if($db->where('ac_id', $data['account_id'])->set($save_data)->update())
        {
            $sup_db = \Config\Database::connect()->table('cwf_suppliers');

            $supplier_table = [
                                'sup_company' => $data['company_name'],
                                'sup_address1' => $data['address1'],
                                'sup_address2' => $data['address2'],
                                'sup_city' => $data['city'],
                                'sup_zip_code' => $data['zip_code'],
                                'sup_country' => $data['country'],
                                'sup_sales_dprt_email' => $data['sales_dprt_email'],
                                'sup_telephone_no' => $data['telephone_no'],
                                'sup_tax_id' => $data['tax_id'],
                                'sup_ref_no' => $data['ref_id'],
                            ];

            if($sup_db->where('sup_ac_id', $data['account_id'])->set($supplier_table)->update())
            {
                session()->setFlashdata("success", "Opration SuccessFul");
                return $this->response->redirect(current_url());
            }else
            {
                session()->setFlashdata("error", "Opration Not Complete");
                return $this->response->redirect(current_url());
            }
            
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }


    public function remove()
    {
        $db = \Config\Database::connect()->table('admin_accounts');

        $save_data = array(
                            'ac_active' => 'D',
                            'ac_updated_ip'  => $this->request->getIPAddress(),
                            'ac_updated_id' => dsession_id(),
                            'ac_updated_at' => date("Y-m-d h:i:s"),
                        );
        

        if($db->where('ac_id', $_GET['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
                return $this->response->redirect(current_url());
            
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}

