<?php 
namespace App\Controllers\Cwf;
use App\Controllers\BaseController;

class SubCategoryController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $db = \Config\Database::connect()->table('cwf_sub_category');
        $data['list'] = $db->where('cwf_sub_cat_active','A')->orderby('cwf_sub_cat_order', 'ASC')->join('cwf_category', 'cwf_sub_cat_parent_id = cwf_category.cwf_cat_id')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Cwf/sub-category/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        $db = \Config\Database::connect()->table('cwf_category');
        $data['list'] = $db->where('cwf_cat_active','A')->orderby('cwf_cat_order', 'ASC')->get()->getResult();


        echo view('Admin/include/header');
        echo view('Cwf/sub-category/add', $data);
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('cwf_sub_category');

            $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data['title'])));
            $results = $db->where('cwf_sub_cat_name', $data['title'])->where('cwf_sub_cat_parent_id', $data['parent_category'])->get()->getResult();
            $results_count = $db->where('cwf_sub_cat_parent_id', $data['parent_category'])->get()->getResult();

            if($results)
            {
                session()->setFlashdata("error", "Sub Category Not Unique");
                return $this->response->redirect(current_url());
            }

            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
                $slug = $slug.'-'.$count_result;
            }

        $save_data = array(
                            'cwf_sub_cat_hash'=> createHash(),
                            'cwf_sub_cat_name'=> $data['title'],
                            'cwf_sub_cat_slug'=> $slug,
                            'cwf_sub_cat_description'=> $data['description'],
                            'cwf_sub_cat_order' => count($results_count)+1,
                            'cwf_sub_cat_status' => $data['status'],
                            'cwf_sub_cat_active' => 'A',
                            'cwf_sub_cat_created_ip' => $this->request->getIPAddress(),
                            'cwf_sub_cat_created_id' => dsession_id(),
                            'cwf_sub_cat_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_sub_cat_updated_id' => dsession_id(),
                            'cwf_sub_cat_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($data['parent_category'])
        {
            $save_data['cwf_sub_cat_parent_id'] = $data['parent_category'];
        }

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $db = \Config\Database::connect()->table('cwf_sub_category');
        $data['cat_data'] = (array) $db->where('cwf_sub_cat_active','A')->where('cwf_sub_cat_hash', $token)->get()->getRow();

        $db = \Config\Database::connect()->table('cwf_category');
        $data['list'] = $db->where('cwf_cat_active','A')->orderby('cwf_cat_order', 'ASC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Cwf/sub-category/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('cwf_sub_category');
        $save_data = array(
                            'cwf_sub_cat_name'=> $data['title'],
                            'cwf_sub_cat_slug'=> $data['slug'],
                            'cwf_sub_cat_description'=> $data['description'],
                            'cwf_sub_cat_status' => $data['status'],
                            'cwf_sub_cat_updated_ip'  => $this->request->getIPAddress(),
                            'cwf_sub_cat_updated_id' => dsession_id(),
                            'cwf_sub_cat_updated_at' => date("Y-m-d h:i:s"),
                        );
        if($data['parent_category'])
        {
            $save_data['cwf_sub_cat_parent_id'] = $data['parent_category'];
        }

        if($db->where('cwf_sub_cat_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}

