<?php 
namespace App\Controllers\Cwf;
use App\Controllers\BaseController;

class StateController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $db = dbconnect('state');
        $data['list'] = $db->where('state_active','A')->where('sate_country_id',$_GET['country'])->orderby('state_order', 'ASC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Cwf/state/list', $data);
        echo view('Admin/include/footer');
    }



    public function ajax_list()
    {
        $db = dbconnect('state');
        $list = $db->where('state_active','A')->where('sate_country_id',$_GET['country'])->orderby('state_order', 'ASC')->get()->getResult();

        echo '<option value="">Select</option>';
        foreach($list as $ls)
        {
            echo "<option value=".$ls->state_id.">".$ls->state_title."</option>";
        }

    }



    // CREATE
    public function create()
    {
        echo view('Admin/include/header');
        echo view('Cwf/state/add');
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $db = dbconnect('state');

           
            $results = $db->where('state_title', $data['title'])->where('state_active','A')->get()->getResult();
            $results_count = $db->where('sate_country_id', $_GET['country'])->get()->getResult();

            if($results)
            {
                session()->setFlashdata("error", "Data Not Unique");
                return $this->response->redirect(current_url());
            }

            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
            }

        $save_data = array(
                            'state_title'=> $data['title'],
                            'state_order' => count($results_count) + 1 ,
                            'state_status' => $data['status'],
                            'sate_country_id' => $_GET['country'],
                            'state_active' => '1',
                            'state_created_at' => date("Y-m-d h:i:s"),
                            'state_created_ip' => $this->request->getIPAddress(),
                            'state_created_id' => dsession_id(),
                            'state_updated_ip'  => $this->request->getIPAddress(),
                            'state_updated_id' => dsession_id(),
                            'state_updated_at' => date("Y-m-d h:i:s"),
                        );

       

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Opration Successful");
            return $this->response->redirect(current_url().'?country='.$_GET['country']);
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url().'?country='.$_GET['country']);
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $db = dbconnect('state');
        $data['cat_data'] = (array) $db->where('state_active','A')->where('state_id', $token)->get()->getRow();
        echo view('Admin/include/header');
        echo view('Cwf/state/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = dbconnect('state');


        $save_data = array(
                            'state_title'=> $data['title'],
                            'state_status' => $data['status'],
                            'state_updated_ip'  => $this->request->getIPAddress(),
                            'state_updated_id' => dsession_id(),
                            'state_updated_at' => date("Y-m-d h:i:s"),
                        );
        

        if($db->where('state_id', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url().'?country='.$_GET['country']);
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url().'?country='.$_GET['country']);
        }

    }

}



