<?php 
namespace App\Controllers\Cwf;
use App\Controllers\BaseController;

class ProductTagsController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $db = dbconnect('cwf_prod_tags');
        $data['list'] = $db->where('cwfpt_active','A')->orderby('cwfpt_order', 'ASC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Cwf/product_tags/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        echo view('Admin/include/header');
        echo view('Cwf/product_tags/add');
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $db = dbconnect('cwf_prod_tags');



            $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data['title'])));
            $results = $db->where('cwfpt_name', $data['title'])->get()->getResult();
            $results_count = $db->get()->getResult();
           
            
            if($results)
            {
                session()->setFlashdata("error", "Color Not Unique");
                return $this->response->redirect(current_url());
            }

        
        if($_FILES['file']['name'])
        {  
            // Image
            $validated = $this->validate([
                'file' => [
                    'uploaded[file]',
                    'mime_in[file,image/jpg,image/jpeg,image/gif,image/png]',
                    'max_size[file,1024]',
                ],
            ]);
            if(!$validated) {
                session()->setFlashdata("error", "Please Upload Valid File");
                return $this->response->redirect(current_url()); 
            }

            $avatar = $this->request->getFile('file');
            $newName = $avatar->getRandomName();
            $avatar->move('./uploads/product-tags/', $newName);
        }else
        {
            $newName = '';
        }



        $save_data = array(
                            'cwfpt_hash'=> createHash(),
                            'cwfpt_name'=> $data['title'],
                            'cwfpt_image' => $newName,
                            'cwfpt_order' => count($results_count) + 1 ,
                            'cwfpt_status' => $data['status'],
                            'cwfpt_active' => 'A',
                            'cwfpt_created_at' => date("Y-m-d h:i:s"),
                            'cwfpt_created_ip' => $this->request->getIPAddress(),
                            'cwfpt_created_id' => dsession_id(),
                            'cwfpt_updated_ip'  => $this->request->getIPAddress(),
                            'cwfpt_updated_id' => dsession_id(),
                            'cwfpt_updated_at' => date("Y-m-d h:i:s"),
                        );

       

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $db = dbconnect('cwf_prod_tags');
        $data['details'] = (array) $db->where('cwfpt_active','A')->where('cwfpt_hash', $token)->get()->getRow();
        echo view('Admin/include/header');
        echo view('Cwf/product_tags/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = dbconnect('cwf_prod_tags');

        if($_FILES['file']['name'])
        {  
            // Image
            $validated = $this->validate([
                'file' => [
                    'uploaded[file]',
                    'mime_in[file,image/jpg,image/jpeg,image/gif,image/png]',
                    'max_size[file,1024]',
                ],
            ]);
            if(!$validated) {
                session()->setFlashdata("error", "Please Upload Valid File");
                return $this->response->redirect(current_url()); 
            }

            $avatar = $this->request->getFile('file');
            $newName = $avatar->getRandomName();
            $avatar->move('./uploads/product-tagpt/', $newName);
        }else
        {
            $newName = '';
        }

        $save_data = array(
                            'cwfpt_name'=> $data['title'],
                            'cwfpt_status' => $data['status'],
                            'cwfpt_updated_ip'  => $this->request->getIPAddress(),
                            'cwfpt_updated_id' => dsession_id(),
                            'cwfpt_updated_at' => date("Y-m-d h:i:s"),
                        );
        
        if($newName)
        {
            $save_data['cwfpt_image'] = $newName;
        }

        if($db->where('cwfpt_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}


?>


