<?php 
namespace App\Controllers\Cwf;
use App\Models\CountryModel;
use App\Models\AccountModel;
use App\Controllers\BaseController;

class LargesseController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                if(isset($_GET['section']) AND $_GET['section'] == 'notes')
                {
                    $this->notesEdit();
                }else
                {
                    $this->edit();
                }
                
            }elseif($action == 'remove')
            {
                $this->remove();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );

                if(isset($_GET['section']) AND $_GET['section'] == 'notes')
                {
                    $this->notesedit_conf($postData, $custome_data);
                }else
                {
                    $this->edit_conf($postData, $custome_data);
                }

                
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $db = \Config\Database::connect()->table('cwf_largesse');
        $data['list'] = $db->where('lrgs_active','A')->get()->getResult();

    


        echo view('Admin/include/header');
        echo view('Cwf/largesse/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        $countrys = new CountryModel();
        $dyanmicData['countrys'] = $countrys->orderBy('country_name', 'ASC')->where('country_active','A')->findAll();
        echo view('Admin/include/header');
        echo view('Cwf/largesse/add', $dyanmicData);
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        

        $db = \Config\Database::connect()->table('cwf_largesse');
        $results = $db->where('lrgs_email', $data['email'])->where('lrgs_active','A')->get()->getResult();

        if($results)
        {
            session()->setFlashdata("error", "Email Already Used!");
            return $this->response->redirect(current_url());
        }

        $save_data = array(
                            'lrgs_hash' => createHash(),
                            'lrgs_fname'=> $data['first_name'],
                            'lrgs_lname'=> $data['last_name'],
                            'lrgs_email'=> $data['email'],
                            'lrgs_mobile'=> $data['mobile_no'],
                            'lrgs_company' => $data['company_name'],
                            'lrgs_address1' => $data['address1'],
                            'lrgs_address2' => $data['address2'],
                            'lrgs_city' => $data['city'],
                            'lrgs_zip_code' => $data['zip_code'],
                            'lrgs_country' => $data['country'],
                            'lrgs_email2' => $data['email2'],
                            'lrgs_telephone_no' => $data['telephone_no'],
                            'lrgs_telephone_no2' => $data['telephone_no2'],
                            'lrgs_no_of_dependencies' => $data['no_of_dependencies'],
                            'lrgs_tax_id' => $data['tax_id'],
                            'lrgs_status' => $data['status'],
                            'lrgs_active' => 'A',
                            'lrgs_notes' => '',
                            'lrgs_created_at' => date("Y-m-d h:i:s"),
                            'lrgs_created_ip' => $this->request->getIPAddress(),
                            'lrgs_created_id' => dsession_id(),
                            'lrgs_updated_ip'  => $this->request->getIPAddress(),
                            'lrgs_updated_id' => dsession_id(),
                            'lrgs_updated_at' => date("Y-m-d h:i:s"),
                        );

        // echo "<pre>";
        // print_r($data);
        // echo "<pre>";
        // exit();       

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $countrys = new CountryModel();
        $data['countrys'] = $countrys->orderBy('country_name', 'ASC')->where('country_active','A')->findAll();

        $db = \Config\Database::connect()->table('cwf_largesse');
        $data['details'] = $db->where('lrgs_hash', $token)->get()->getRow();

        // echo "<pre>";
        // print_r($data['details']);
        // exit();

        echo view('Admin/include/header');
        echo view('Cwf/largesse/edit', $data);
        echo view('Admin/include/footer');
    }

    public function notesEdit()
    {
        $token = $this->request->getGet('token');
        $db = \Config\Database::connect()->table('cwf_largesse');
        $data['details'] = $db->where('lrgs_id', $token)->get()->getRow();

        $notesArray = explode(',', $data['details']->lrgs_notes);

        $db = \Config\Database::connect()->table('cwf_notes');
        $data['notes'] = $db->where('cwfn_active', 'A')->where('cwfn_status','A')->wherein('cwfn_id', $notesArray)->orderby('cwfn_id', 'DESC')->join('admin_accounts', 'cwfn_sender_id = admin_accounts.ac_id')->get()->getResult();

        echo view('Admin/include/header');
        echo view('Cwf/largesse/notes_edit', $data);
        echo view('Admin/include/footer');
    }

    public function notesedit_conf($data, $custome_data)
    {
        // echo "<pre>";
        // print_r($data);
        $db = \Config\Database::connect()->table('cwf_notes');
        $hash_key = createHash();

        $save_data = array(
                            'cwfn_hash' => $hash_key,
                            'cwfn_sender_id'=> dsession_id(),
                            'cwfn_message'=> $data['message'],
                            'cwfn_status' => 'A',
                            'cwfn_active' => 'A',
                            'cwfn_created_at' => date("Y-m-d h:i:s"),
                            'cwfn_created_ip' => $this->request->getIPAddress(),
                            'cwfn_created_id' => dsession_id(),
                            'cwfn_updated_ip'  => $this->request->getIPAddress(),
                            'cwfn_updated_id' => dsession_id(),
                            'cwfn_updated_at' => date("Y-m-d h:i:s"),
                        );

        if($db->insert($save_data))
        {   
            $details = $db->where('cwfn_hash', $hash_key)->get()->getRow();

            $db = \Config\Database::connect()->table('cwf_largesse');
            $largesseData = $db->where('lrgs_id', $data['token'])->get()->getRow();

            $notesArray = explode(',', $largesseData->lrgs_notes);
            $notesArray[] = $details->cwfn_id;

            $notesUpdatedData = implode(',', $notesArray);

            $update_data = array(
                            'lrgs_notes'=> $notesUpdatedData ,
                            'lrgs_updated_ip'  => $this->request->getIPAddress(),
                            'lrgs_updated_id' => dsession_id(),
                            'lrgs_updated_at' => date("Y-m-d h:i:s"),
                        );
            if($db->where('lrgs_id', $data['token'])->set($update_data)->update())
            {
               
                session()->setFlashdata("success", "Opration SuccessFul");
                return $this->response->redirect(current_url().'?action=edit&token='.$data['token'].'&section=notes');

            }else
            {
                session()->setFlashdata("error", "Largesse DB Not Updated");
                return $this->response->redirect(current_url().'?action=edit&token='.$data['token'].'&section=notes');
            }
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url().'?action=edit&token='.$data['token'].'&section=notes');
        }

    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('cwf_largesse');

        $save_data = array(
                            'lrgs_fname'=> $data['first_name'],
                            'lrgs_lname'=> $data['last_name'],
                            'lrgs_email'=> $data['email'],
                            'lrgs_mobile'=> $data['mobile_no'],
                            'lrgs_company' => $data['company_name'],
                            'lrgs_address1' => $data['address1'],
                            'lrgs_address2' => $data['address2'],
                            'lrgs_city' => $data['city'],
                            'lrgs_zip_code' => $data['zip_code'],
                            'lrgs_country' => $data['country'],
                            'lrgs_email2' => $data['email2'],
                            'lrgs_telephone_no' => $data['telephone_no'],
                            'lrgs_telephone_no2' => $data['telephone_no2'],
                            'lrgs_no_of_dependencies' => $data['no_of_dependencies'],
                            'lrgs_tax_id' => $data['tax_id'],
                            'lrgs_status' => $data['status'],
                            'lrgs_updated_ip'  => $this->request->getIPAddress(),
                            'lrgs_updated_id' => dsession_id(),
                            'lrgs_updated_at' => date("Y-m-d h:i:s"),
                        );
        

        if($db->where('lrgs_id', $data['account_id'])->set($save_data)->update())
        {
           
            session()->setFlashdata("success", "Opration SuccessFul");
                return $this->response->redirect(current_url());

        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }


    public function remove()
    {
        $db = \Config\Database::connect()->table('cwf_largesse');

        $save_data = array(
                            'lrgs_active' => 'D',
                            'lrgs_updated_ip'  => $this->request->getIPAddress(),
                            'lrgs_updated_id' => dsession_id(),
                            'lrgs_updated_at' => date("Y-m-d h:i:s"),
                        );
        

        if($db->where('lrgs_id', $_GET['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
                return $this->response->redirect(current_url());
            
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}

