<?php 
namespace App\Controllers\Cwf;
use App\Models\CountryModel;
use App\Models\AccountModel;
use App\Controllers\BaseController;

class ClientController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                if(isset($_GET['section']) AND $_GET['section'] == 'notes')
                {
                    $this->notesEdit();
                }else
                {
                    $this->edit();
                }
            }elseif($action == 'remove')
            {
                $this->remove();
            }
             elseif($action == 'show')
            {
                $this->show();  
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );

                if(isset($_GET['section']) AND $_GET['section'] == 'notes')
                {
                    $this->notesedit_conf($postData, $custome_data);
                }else
                {
                    $this->edit_conf($postData, $custome_data);
                }
                
            }
        }else
        {
            $this->list();
        }
    }




    // LIST
    public function list()
    {
        $db = \Config\Database::connect()->table('cwf_clients');
        $data['list'] = $db->join('admin_accounts', 'clnt_ac_id = admin_accounts.ac_id')->where('ac_active','A')->join('account_type', 'ac_type = account_type.at_id')->where('at_code', 'C')->get()->getResult();

    


        echo view('Admin/include/header');
        echo view('Cwf/clients/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        $countrys = new CountryModel();
        $dyanmicData['countrys'] = $countrys->orderBy('country_name', 'ASC')->where('country_active','A')->findAll();
        echo view('Admin/include/header');
        echo view('Cwf/clients/add', $dyanmicData);
        echo view('Admin/include/footer');
    }

  public function generateRandomAlphaNumeric($length = 6) {
    $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $randomString;
}
    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        

        // $db = \Config\Database::connect()->table('admin_accounts');
        $db = new AccountModel();

        $results = $db->where('ac_email', $data['email'])->get()->getResult();
        $results_count = $db->get()->getResult();

        if($results)
        {
            session()->setFlashdata("error", "Email Already Used!");
            return $this->response->redirect(current_url());
        }

        $save_data = array(
                            'clint_code'=> "CFC-".$this->generateRandomAlphaNumeric(),
                            'ac_fname'=> $data['first_name'],
                            'ac_lname'=> $data['last_name'],
                            'ac_email'=> $data['email'],
                            'ac_contact_no'=> $data['mobile_no'],
                            'ac_status' => $data['status'],
                            'ac_active' => 'A',
                            'ac_type' => '7',
                            'ac_password' => md5(rand(100000,99999999)),
                            'ac_created_at' => date("Y-m-d h:i:s"),
                            'ac_created_ip' => $this->request->getIPAddress(),
                            'ac_created_id' => dsession_id(),
                            'ac_updated_ip'  => $this->request->getIPAddress(),
                            'ac_updated_id' => dsession_id(),
                            'ac_updated_at' => date("Y-m-d h:i:s"),
                        );

        // echo "<pre>";
        // print_r($data);
        // echo "<pre>";
        // exit();       

        if($db->insert($save_data))
        {

            $sup_db = \Config\Database::connect()->table('cwf_clients');
            $current_time = getdate();
            $client_table = [
                                'clnt_hash' => createHash(),
                                'clnt_ac_id' => $db->getInsertID(),
                                'clnt_company' => $data['company_name'],
                                'clnt_address1' => $data['address1'],
                                'clnt_address2' => $data['address2'],
                                'clnt_city' => $data['city'],
                                'clnt_zip_code' => $data['zip_code'],
                                'clnt_country' => $data['country'],
                                'clnt_email2' => $data['email2'],
                                'clnt_telephone_no' => $data['telephone_no'],
                                'clnt_telephone_no2' => $data['telephone_no2'],
                                'clnt_tax_id' => $data['tax_id'],
                            ];

            if($sup_db->insert($client_table))
            {
                session()->setFlashdata("success", "Opration SuccessFul");
                return $this->response->redirect(current_url());
            }else
            {
                session()->setFlashdata("error", "Opration Not Complete");
                return $this->response->redirect(current_url());
            }
            
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $countrys = new CountryModel();
        $data['countrys'] = $countrys->orderBy('country_name', 'ASC')->where('country_active','A')->findAll();

        $db = \Config\Database::connect()->table('cwf_clients');
        $data['details'] = $db->where('clnt_hash', $token)->join('admin_accounts', 'clnt_ac_id = admin_accounts.ac_id')->where('ac_active','A')->join('account_type', 'ac_type = account_type.at_id')->where('at_code', 'C')->get()->getRow();

        // echo "<pre>";
        // print_r($data['details']);
        // exit();

        echo view('Admin/include/header');
        echo view('Cwf/clients/edit', $data);
        echo view('Admin/include/footer');
    } 

    // SHOW
    public function show()
    {
        $token = $this->request->getGet('token');

        $countrys = new CountryModel();
        $data['countrys'] = $countrys->orderBy('country_name', 'ASC')->where('country_active','A')->findAll();

        $db = \Config\Database::connect()->table('cwf_clients');
        $data['details'] = $db->where('clnt_hash', $token)->join('admin_accounts', 'clnt_ac_id = admin_accounts.ac_id')->where('ac_active','A')->join('account_type', 'ac_type = account_type.at_id')->where('at_code', 'C')->get()->getRow();

        echo view('Admin/include/header');
        echo view('Cwf/clients/show', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('admin_accounts');

        $save_data = array(
                            'ac_fname'=> $data['first_name'],
                            'ac_lname'=> $data['last_name'],
                            'ac_email'=> $data['email'],
                            'ac_contact_no'=> $data['mobile_no'],
                            'ac_status' => $data['status'],
                            'ac_updated_ip'  => $this->request->getIPAddress(),
                            'ac_updated_id' => dsession_id(),
                            'ac_updated_at' => date("Y-m-d h:i:s"),
                        );
        

        if($db->where('ac_id', $data['account_id'])->set($save_data)->update())
        {
            $sup_db = \Config\Database::connect()->table('cwf_clients');

            $supplier_table = [
                                'clnt_company' => $data['company_name'],
                                'clnt_address1' => $data['address1'],
                                'clnt_address2' => $data['address2'],
                                'clnt_city' => $data['city'],
                                'clnt_zip_code' => $data['zip_code'],
                                'clnt_country' => $data['country'],
                                'clnt_email2' => $data['email2'],
                                'clnt_telephone_no' => $data['telephone_no'],
                                'clnt_telephone_no2' => $data['telephone_no2'],
                                'clnt_tax_id' => $data['tax_id'],
                            ];

            if($sup_db->where('clnt_ac_id', $data['account_id'])->set($supplier_table)->update())
            {
                session()->setFlashdata("success", "Opration SuccessFul");
                return $this->response->redirect(current_url());
            }else
            {
                session()->setFlashdata("error", "Opration Not Complete");
                return $this->response->redirect(current_url());
            }
            
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }


    public function remove()
    {
        $db = \Config\Database::connect()->table('admin_accounts');

        $save_data = array(
                            'ac_active' => 'D',
                            'ac_updated_ip'  => $this->request->getIPAddress(),
                            'ac_updated_id' => dsession_id(),
                            'ac_updated_at' => date("Y-m-d h:i:s"),
                        );
        

        if($db->where('ac_id', $_GET['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
                return $this->response->redirect(current_url());
            
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }





    public function notesEdit()
    {
        $token = $this->request->getGet('token');
        $db = \Config\Database::connect()->table('cwf_clients');
        $data['details'] = $db->where('clnt_id', $token)->join('admin_accounts', 'clnt_ac_id = admin_accounts.ac_id')->get()->getRow();

        // echo "<pre>";
        // print_r($data);
        // exit();

        $notesArray = explode(',', $data['details']->clnt_notes);

        $db = \Config\Database::connect()->table('cwf_notes');
        $data['notes'] = $db->where('cwfn_active', 'A')->where('cwfn_status','A')->wherein('cwfn_id', $notesArray)->orderby('cwfn_id', 'DESC')->join('admin_accounts', 'cwfn_sender_id = admin_accounts.ac_id')->get()->getResult();

        echo view('Admin/include/header');
        echo view('Cwf/clients/notes_edit', $data);
        echo view('Admin/include/footer');
    }

    public function notesedit_conf($data, $custome_data)
    {
        // echo "<pre>";
        // print_r($data);
        $db = \Config\Database::connect()->table('cwf_notes');

        // $db = \Config\Database::connect()->table('cwf_notess');

        // $db->get()->getResult();

        // echo "<pre>";
        // print_r($db->get()->getResult());
        // exit();


        $hash_key = createHash();

        $save_data = array(
                            'cwfn_hash' => $hash_key,
                            'cwfn_sender_id'=> dsession_id(),
                            'cwfn_message'=> $data['message'],
                            'cwfn_status' => 'A',
                            'cwfn_active' => 'A',
                            'cwfn_created_at' => date("Y-m-d h:i:s"),
                            'cwfn_created_ip' => $this->request->getIPAddress(),
                            'cwfn_created_id' => dsession_id(),
                            'cwfn_updated_ip'  => $this->request->getIPAddress(),
                            'cwfn_updated_id' => dsession_id(),
                            'cwfn_updated_at' => date("Y-m-d h:i:s"),
                        );

        

        if($db->insert($save_data))
        {   
            $details = $db->where('cwfn_hash', $hash_key)->get()->getRow();

            $db = \Config\Database::connect()->table('cwf_clients');
            $largesseData = $db->where('clnt_id', $data['token'])->get()->getRow();

            $notesArray = explode(',', $largesseData->clnt_notes);
            $notesArray[] = $details->cwfn_id;

            $notesUpdatedData = implode(',', $notesArray);

            $update_data = array(
                            'clnt_notes'=> $notesUpdatedData ,
                        );
            if($db->where('clnt_id', $data['token'])->set($update_data)->update())
            {
               
                session()->setFlashdata("success", "Opration SuccessFul");
                return $this->response->redirect(current_url().'?action=edit&token='.$data['token'].'&section=notes');

            }else
            {
                session()->setFlashdata("error", "Largesse DB Not Updated");
                return $this->response->redirect(current_url().'?action=edit&token='.$data['token'].'&section=notes');
            }
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url().'?action=edit&token='.$data['token'].'&section=notes');
        }

    }










}

