<?php 
namespace App\Controllers\Cwf;
use App\Controllers\BaseController;

class CityController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $db = dbconnect('city');
        $data['list'] = $db->where('city_active','A')->where('city_state_id',$_GET['state'])->orderby('city_order', 'ASC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Cwf/city/list', $data);
        echo view('Admin/include/footer');
    }



    public function ajax_list()
    {
        $db = dbconnect('city');
        $list = $db->where('city_active','A')->where('city_state_id',$_GET['state'])->orderby('city_order', 'ASC')->get()->getResult();

        echo '<option value="">Select</option>';
        foreach($list as $ls)
        {
            echo "<option value=".$ls->city_id.">".$ls->city_title."</option>";
        }

    }



    // CREATE
    public function create()
    {
        echo view('Admin/include/header');
        echo view('Cwf/city/add');
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $db = dbconnect('city');

           
            $results = $db->where('city_name', $data['title'])->where('city_active','A')->get()->getResult();
            $results_count = $db->where('city_state_id', $_GET['state'])->get()->getResult();

            if($results)
            {
                session()->setFlashdata("error", "Data Not Unique");
                return $this->response->redirect(current_url());
            }

            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
            }

        $save_data = array(
                            'city_name'=> $data['title'],
                            'city_order' => count($results_count) + 1 ,
                            'city_status' => $data['status'],
                            'city_state_id' => $_GET['state'],
                            'city_active' => '1',
                            'city_created_at' => date("Y-m-d h:i:s"),
                            'city_created_ip' => $this->request->getIPAddress(),
                            'city_created_id' => dsession_id(),
                            'city_updated_ip'  => $this->request->getIPAddress(),
                            'city_updated_id' => dsession_id(),
                            'city_updated_at' => date("Y-m-d h:i:s"),
                        );

       

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Opration Successful");
            return $this->response->redirect(current_url().'?state='.$_GET['state']);
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url().'?state='.$_GET['state']);
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $db = dbconnect('city');
        $data['cat_data'] = (array) $db->where('city_active','A')->where('city_id', $token)->get()->getRow();
        echo view('Admin/include/header');
        echo view('Cwf/city/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = dbconnect('city');


        $save_data = array(
                            'city_name'=> $data['title'],
                            'city_status' => $data['status'],
                            'city_updated_ip'  => $this->request->getIPAddress(),
                            'city_updated_id' => dsession_id(),
                            'city_updated_at' => date("Y-m-d h:i:s"),
                        );
        

        if($db->where('city_id', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url().'?state='.$_GET['state']);
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url().'?state='.$_GET['state']);
        }

    }

}



