<?php 
namespace App\Controllers\Admin;
use App\Models\TagModel;
use App\Controllers\BaseController;

class TagController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $list = new TagModel();
        $data['list'] = $list->where('tag_active','A')->orderby('tag_id', 'DESC')->findAll();
        echo view('Admin/include/header');
        echo view('Admin/tag/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        $list = new TagModel();
        $data['list'] = $list->where('tag_active','A')->orderby('tag_id', 'DESC')->findAll();
        echo view('Admin/include/header');
        echo view('Admin/tag/add', $data);
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $tag = new TagModel();
        if($data['slug'])
        {
            $slug = $data['slug'];
        }else
        {
            $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data['title'])));
            $results = $tag->where('tag_name', $data['title'])->findAll();
            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
                $slug = $slug.'-'.$count_result;
            }
        }

        $save_data = array(
                            'tag_hash'=> createHash(),
                            'tag_name'=> $data['title'],
                            'tag_slug'=> $slug,
                            'tag_description'=> $data['description'],
                            'tag_status' => $data['status'],
                            'tag_active' => 'A',
                            'tag_created_id' => dsession_id(),
                        );


        if($tag->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $list = new TagModel();
        $data['tag_data'] = $list->where('tag_active','A')->where('tag_hash', $token)->first();
        $data['list'] = $list->where('tag_active','A')->orderby('tag_id', 'DESC')->findAll();
        echo view('Admin/include/header');
        echo view('Admin/tag/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $tag = new TagModel();
        $save_data = array(
                            'tag_name'=> $data['title'],
                            'tag_slug'=> $data['slug'],
                            'tag_description'=> $data['description'],
                            'tag_status' => $data['status'],
                            'tag_updated_at' => date("Y-m-d h:i:s"),
                            'tag_updated_id' => dsession_id(),
                        );

        if($tag->where('tag_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}

