<?php 
namespace App\Controllers\Admin;
use App\Models\SocialLinkModel;
use App\Controllers\BaseController;

class SocialLinkController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $list = new SocialLinkModel();
        $data['list'] = $list->where('sl_active','A')->orderby('sl_id', 'DESC')->findAll();
        echo view('Admin/include/header');
        echo view('Admin/social_link/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        $list = new SocialLinkModel();
        $data['list'] = $list->where('sl_active','A')->orderby('sl_id', 'DESC')->findAll();
        echo view('Admin/include/header');
        echo view('Admin/social_link/add', $data);
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $model = new SocialLinkModel();
        $save_data = array(
                            'sl_hash'=> createHash(),
                            'sl_name'=> $data['title'],
                            'sl_icon'=> $data['icon'],
                            'sl_link'=> $data['slug'],
                            'sl_status' => $data['status'],
                            'sl_active' => 'A',
                            'sl_created_at' => date("Y-m-d h:i:s"),
                            'sl_updated_at' => date("Y-m-d h:i:s"),
                            'sl_created_id' => dsession_id(),
                            'sl_updated_id' => dsession_id(),
                        );


        if($model->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $list = new SocialLinkModel();
        $data['social_data'] = $list->where('sl_active','A')->where('sl_hash', $token)->first();
        $data['list'] = $list->where('sl_active','A')->orderby('sl_id', 'DESC')->findAll();
        echo view('Admin/include/header');
        echo view('Admin/social_link/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $tag = new SocialLinkModel();
        $save_data = array(
                            'sl_name'=> $data['title'],
                            'sl_icon'=> $data['icon'],
                            'sl_link'=> $data['slug'],
                            'sl_status' => $data['status'],
                            'sl_updated_at' => date("Y-m-d h:i:s"),
                            'sl_updated_id' => dsession_id(),
                        );

        if($tag->where('sl_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}

