<?php 
namespace App\Controllers\Admin;
use App\Controllers\BaseController;

class SectionController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {

        $db = \Config\Database::connect()->table('sections');
        if(isset($_GET['parent']))
        {
            $data['list'] = $db->where('section_active','A')->orderby('section_id', 'DESC')->join('section_categorys', 'section_category = section_categorys.section_cat_id')->where('section_category', $_GET['parent'])->get()->getResult();
        }else
        {
            $data['list'] = $db->where('section_active','A')->orderby('section_id', 'DESC')->join('section_categorys', 'section_category = section_categorys.section_cat_id')->get()->getResult();
        }

        
        echo view('Admin/include/header');
        echo view('Admin/section/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        $db = \Config\Database::connect()->table('section_categorys');
        $data['list'] = $db->where('section_cat_active','A')->where('section_cat_status', 'A')->orderby('section_cat_name', 'ASC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Admin/section/add', $data);
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('sections');

            $short_code = strtoupper(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data['title'])));
            $results = $db->where('section_name', $data['title'])->get()->getResult();
            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
                $short_code = $short_code.'-'.$count_result;
            }

        $save_data = array(
                            'section_hash'=> createHash(),
                            'section_name'=> $data['title'],
                            'section_short_code' => $short_code,
                            'section_category'=> $data['parent_category'],
                            'section_content_html'=> $data['html_content'],
                            'section_content_css'=> $data['css_content'],
                            'section_content_js'=> $data['js_content'],
                            'section_status' => $data['status'],
                            'section_active' => 'A',
                            'section_created_ip' => $this->request->getIPAddress(),
                            'section_created_id' => dsession_id(),
                            'section_updated_ip'  => $this->request->getIPAddress(),
                            'section_updated_id' => dsession_id(),
                            'section_updated_at' => date("Y-m-d h:i:s"),
                        );

       

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $db = \Config\Database::connect()->table('sections');
        $data['details'] = (array) $db->where('section_active','A')->where('section_hash', $token)->get()->getRow();

        $db = \Config\Database::connect()->table('section_categorys');
        $data['list'] = $db->where('section_cat_active','A')->where('section_cat_status', 'A')->orderby('section_cat_name', 'ASC')->get()->getResult();

        echo view('Admin/include/header');
        echo view('Admin/section/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('sections');
        $save_data = array(
                            'section_name'=> $data['title'],
                            'section_category'=> $data['parent_category'],
                            'section_content_html'=> $data['html_content'],
                            'section_content_css'=> $data['css_content'],
                            'section_content_js'=> $data['js_content'],
                            'section_status' => $data['status'],
                            'section_updated_ip'  => $this->request->getIPAddress(),
                            'section_updated_id' => dsession_id(),
                            'section_updated_at' => date("Y-m-d h:i:s"),
                        );
        
        if($db->where('section_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}

