<?php 
namespace App\Controllers\Admin;
use App\Controllers\BaseController;

class SectionCategoryController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $db = \Config\Database::connect()->table('section_categorys');
        $data['list'] = $db->where('section_cat_active','A')->orderby('section_cat_name', 'ASC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Admin/section-category/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        echo view('Admin/include/header');
        echo view('Admin/section-category/add');
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('section_categorys');

        $results = $db->where('section_cat_name', $data['title'])->get()->getResult();
        if($results)
        {
            session()->setFlashdata("error", "Section Category Not Unique");
            return $this->response->redirect(current_url());
        }

        $save_data = array(
                            'section_cat_hash'=> createHash(),
                            'section_cat_name'=> $data['title'],
                            'section_cat_description'=> $data['description'],
                            'section_cat_status' => $data['status'],
                            'section_cat_active' => 'A',
                            'section_cat_created_ip' => $this->request->getIPAddress(),
                            'section_cat_created_id' => dsession_id(),
                            'section_cat_updated_ip'  => $this->request->getIPAddress(),
                            'section_cat_updated_id' => dsession_id(),
                            'section_cat_updated_at' => date("Y-m-d h:i:s"),
                        );

       

        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $db = \Config\Database::connect()->table('section_categorys');
        $data['cat_data'] = (array) $db->where('section_cat_active','A')->where('section_cat_hash', $token)->get()->getRow();
        echo view('Admin/include/header');
        echo view('Admin/section-category/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('section_categorys');
        $save_data = array(
                            'section_cat_name'=> $data['title'],
                            'section_cat_description'=> $data['description'],
                            'section_cat_status' => $data['status'],
                            'section_cat_updated_ip'  => $this->request->getIPAddress(),
                            'section_cat_updated_id' => dsession_id(),
                            'section_cat_updated_at' => date("Y-m-d h:i:s"),
                        );
        

        if($db->where('section_cat_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}

