<?php 
namespace App\Controllers\Admin;
use App\Models\PostModel;
use App\Models\CategoryModel;
use App\Models\TagModel;
use App\Controllers\BaseController;

class PostController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $list = new postModel();
        $data['list'] = $list->where('post_active','A')->orderby('post_id', 'DESC')->findAll();
        echo view('Admin/include/header');
        echo view('Admin/post/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        $list = new postModel();
        $data['list'] = $list->where('post_active','A')->orderby('post_id', 'DESC')->findAll();
        $cat_list = new CategoryModel();
        $data['cat_list'] = $cat_list->where('cat_active','A')->orderby('cat_id', 'DESC')->findAll();
        $tag_list = new TagModel();
        $data['tag_list'] = $tag_list->where('tag_active','A')->orderby('tag_id', 'DESC')->findAll();

        echo view('Admin/include/header');
        echo view('Admin/post/add', $data);
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $post = new postModel();
        if($data['slug'])
        {
            $slug = $data['slug'];
        }else
        {
            $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data['title'])));
            $results = $post->where('post_title', $data['title'])->findAll();
            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
                $slug = $slug.'-'.$count_result;
            }
        }
        $save_data = array(
                            'post_hash'=> createHash(),
                            'post_title'=> $data['title'],
                            'post_slug'=> $slug,
                            'post_content'=> $data['description'],
                            'post_categorys' => implode(',', $data['category']),
                            'post_tags' => implode(',', $data['tags']),
                            'post_excerpt' => $data['excerpt'],
                            'post_author' => dsession_id(),
                            'post_status' => $data['status'],
                            'post_active' => 'A',
                            'post_created_id' => dsession_id(),
                        );
        if($post->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $list = new postModel();
        $data['single_data'] = $list->where('post_active','A')->where('post_hash', $token)->first();
        $data['list'] = $list->where('post_active','A')->orderby('post_id', 'DESC')->findAll();

        $cat_list = new CategoryModel();
        $data['cat_list'] = $cat_list->where('cat_active','A')->orderby('cat_id', 'DESC')->findAll();
        $tag_list = new TagModel();
        $data['tag_list'] = $tag_list->where('tag_active','A')->orderby('tag_id', 'DESC')->findAll();

        echo view('Admin/include/header');
        echo view('Admin/post/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $post = new postModel();

        if($data['slug'])
        {
            $slug = $data['slug'];
        }else
        {
            $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data['title'])));
            $results = $post->where('post_title', $data['title'])->findAll();
            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
                $slug = $slug.'-'.$count_result;
            }
        }

        $save_data = array(
                            'post_title'=> $data['title'],
                            'post_slug'=> $slug,
                            'post_content'=> $data['description'],
                            'post_categorys' => implode(',', $data['category']),
                            'post_tags' => implode(',', $data['tags']),
                            'post_excerpt' => $data['excerpt'],
                            'post_author' => dsession_id(),
                            'post_status' => $data['status'],
                            'post_updated_at' => date("Y-m-d h:i:s"),
                            'post_updated_id' => dsession_id(),
                        );

        if($post->where('post_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }


    public function live_preview()
    {
        $token = $this->request->getGet('token');

        $post = new PostModel();
        $data['preview'] = $post->where('post_hash', $token)->first();

        echo view('template/header');
        echo view('template/preview', $data);
        echo view('template/footer');
    }



}

