<?php 
namespace App\Controllers\Admin;
use App\Controllers\BaseController;

class NewsletterController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $this->list();
    }

    
    // LIST
    public function list()
    {
        $db = dbconnect('newsletter');
        $data['list'] = $db->orderby('nl_id', 'DESC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Admin/newsletter/list', $data);
        echo view('Admin/include/footer');
    }





    // Public function Add NewsLetter

    public function addNewsLetter()
    {
        $db = dbconnect('newsletter');
        $save_data = array(
                            'nl_hash'=> createHash(),
                            'nl_email'=> $this->request->getVar('nemail'),
                            'nl_created_at' => date("Y-m-d h:i:s"),
                            'nl_ip' => $this->request->getIPAddress(),
                        );

        if($db->insert($save_data))
        {
            $resData = [
                            'status' => true,
                            'message' => 'NewsLetter Added'
                        ];
        }else
        {
            $resData = [
                            'status' => false,
                            'message' => 'NewsLetter Not Added'
                        ];
        }
        echo json_encode($resData);
    }






}

