<?php 
namespace App\Controllers\Admin;
use App\Controllers\BaseController;

class MenuController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $db = \Config\Database::connect()->table('fe_menu_type');
        $data['list'] = $db->where('femt_active','A')->orderby('femt_name', 'ASC')->get()->getResult();
        echo view('Admin/include/header');
        echo view('Admin/menus/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        echo view('Admin/include/header');
        echo view('Admin/menus/add');
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('fe_menu_type');

        $results = $db->where('femt_name', $data['title'])->get()->getResult();
        if($results)
        {
            session()->setFlashdata("error", "Menu Name Not Unique");
            return $this->response->redirect(current_url());
        }

        $code = strtoupper(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $data['title'])));
            if($results)
            {
                $count_result = count($results);
                $count_result = $count_result + 1;
                $code = $code.'-'.$count_result;
            }

        $save_data = array(
                            'femt_hash'=> createHash(),
                            'femt_name'=> $data['title'],
                            'femt_code'=> $code,
                            'femt_status' => $data['status'],
                            'femt_active' => 'A',
                            'femt_created_ip' => $this->request->getIPAddress(),
                            'femt_created_id' => dsession_id(),
                            'femt_updated_ip'  => $this->request->getIPAddress(),
                            'femt_updated_id' => dsession_id(),
                            'femt_updated_at' => date("Y-m-d h:i:s"),
                        );
    
        if($db->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');
        $db = \Config\Database::connect()->table('fe_menu_type');
        $data['cat_data'] = (array) $db->where('femt_active','A')->where('femt_hash', $token)->get()->getRow();
        echo view('Admin/include/header');
        echo view('Admin/menus/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $db = \Config\Database::connect()->table('fe_menu_type');
        $save_data = array(
                            'femt_name'=> $data['title'],
                            'femt_status' => $data['status'],
                            'femt_updated_ip'  => $this->request->getIPAddress(),
                            'femt_updated_id' => dsession_id(),
                            'femt_updated_at' => date("Y-m-d h:i:s"),
                        );
        
        if($db->where('femt_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}

