<?php 
namespace App\Controllers\Admin;
use App\Models\ImageSliderGroupModel;
use App\Controllers\BaseController;

class ImageSliderGroupController extends BaseController
{   
    // without action = List
    // ?action=create = Create 
    // ?action=edit   = Edit

    // GET REQUEST
    public function index()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                $this->create();  
            }elseif($action == 'edit')
            {
                $this->edit();
            }
        }else
        {
            $this->list();
        }
    }

    // POST REQUEST 
    public function index_post()
    {
        $action = $this->request->getGet('action');
        if($action)
        {   
            if($action == 'create')
            {
                    $postData = $this->request->getVar();
                    $custome_data = array();
                    $this->create_conf($postData, $custome_data);
            }elseif($action == 'edit')
            {
                $postData = $this->request->getVar();
                $custome_data = array(
                                        'token' => $_GET['token'],
                                    );
                $this->edit_conf($postData, $custome_data);
            }
        }else
        {
            $this->list();
        }
    }

    // LIST
    public function list()
    {
        $list = new ImageSliderGroupModel();
        $data['list'] = $list->where('isg_active','A')->orderby('isg_id', 'DESC')->findAll();
        echo view('Admin/include/header');
        echo view('Admin/image_slider_group/list', $data);
        echo view('Admin/include/footer');
    }

    // CREATE
    public function create()
    {
        echo view('Admin/include/header');
        echo view('Admin/image_slider_group/add' );
        echo view('Admin/include/footer');
    }

    // CREATE POST 
    public function create_conf($data, $custome_data)
    {
        $main_model = new ImageSliderGroupModel();
        
        $code = SLIDER_PREFIX.rand(9999,99999);

        $save_data = array(
                            'isg_hash'=> createHash(),
                            'isg_name'=> $data['title'],
                            'isg_code'=> $code,
                            'isg_status' => $data['status'],
                            'isg_active' => 'A',
                            'isg_created_at' => date("Y-m-d h:i:s"),
                            'isg_updated_at' => date("Y-m-d h:i:s"),
                            'isg_created_id' => dsession_id(),
                            'isg_updated_id' => dsession_id(),
                        );


        if($main_model->insert($save_data))
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }
    }

    // EDIT
    public function edit()
    {
        $token = $this->request->getGet('token');

        $main_model = new ImageSliderGroupModel();
        $data['data'] = $main_model->where('isg_active','A')->where('isg_hash', $token)->first();
        if(!$data['data']){return $this->response->redirect(site_url());}
        echo view('Admin/include/header');
        echo view('Admin/image_slider_group/edit', $data);
        echo view('Admin/include/footer');
    }

    // Edit Conf
    public function edit_conf($data, $custome_data)
    {
        $main_model = new ImageSliderGroupModel();
        $save_data = array(
                            'isg_name'=> $data['title'],
                            'isg_status' => $data['status'],
                            'isg_updated_at' => date("Y-m-d h:i:s"),
                            'isg_updated_id' => dsession_id(),
                        );

        if($main_model->where('isg_hash', $data['token'])->set($save_data)->update())
        {
            session()->setFlashdata("success", "Opration SuccessFul");
            return $this->response->redirect(current_url());
        }else
        {
            session()->setFlashdata("error", "Opration Not Complete");
            return $this->response->redirect(current_url());
        }

    }

}

