<?php 
namespace App\Controllers\Admin;
use App\Models\Account_typeModel;
use App\Controllers\BaseController;

class AccounttypeController extends BaseController
{

	public function index()
	{

		$account_typeModel = new Account_typeModel();
        $dyanmicData['at_list'] = $account_typeModel->orderBy('at_id', 'DESC')->findAll();

        echo view('Admin/include/header');
		echo view('Admin/account_type/list', $dyanmicData);
		echo view('Admin/include/footer');
        
	}
    

	public function add()
	{
		$this->template('Admin/account_type/add');
	}

	public function addConf()
	{
        if(!empty($this->request->getVar('mega_menu')))
        {
            $mega_menu_ids = implode(',', $this->request->getVar('mega_menu'));
        }else
        {
            $mega_menu_ids = '';
        }
        if(!empty($this->request->getVar('sub_menu_items')))
        {
            $sub_menu_items = implode(',', $this->request->getVar('sub_menu_items'));
        }else
        {
            $sub_menu_items = '';
        }
        // echo "<pre>";
        // print_r($this->request->getVar());
        // exit();
        $parent_id = $this->request->getGet('id');
		$account_typeModel = new Account_typeModel();
        $data = [
            'at_title' => $this->request->getVar('title'),
            'at_code' => $this->request->getVar('code'),
            'at_menu_privileges'  => $mega_menu_ids,
            'at_menu_item_privileges'  => $sub_menu_items,
            'at_status'  => $this->request->getVar('status'),
            'at_created_ip'  => $this->request->getIPAddress(),
            'at_created_id' => dsession_id(),
            'at_created_at' => date("Y-m-d h:i:s"),
            'at_active'=> 'A'
        ];
        if($account_typeModel->insert($data))
        {
        	session()->setFlashdata("success", "Opration Successfull...");
        	return $this->response->redirect(site_url('admin/account-type'));
        }else
        {
        	session()->setFlashdata("error", "Opration Not Completed...");
        	return $this->response->redirect(site_url('admin/account-type'));
        }
	}

    public function edit()
    {
        $acTypeid = $this->request->getGet('acTypeid');
        $acData = new Account_typeModel();
        $data['acdata'] = $acData->where('at_id', $acTypeid)->first();

        echo view('Admin/include/header');
        echo view('Admin/account_type/edit', $data);
        echo view('Admin/include/footer');
    }
    public function editConf()
    {
        if(!empty($this->request->getVar('mega_menu')))
        {
            $mega_menu_ids = implode(',', $this->request->getVar('mega_menu'));
        }else
        {
            $mega_menu_ids = '';
        }
        if(!empty($this->request->getVar('sub_menu_items')))
        {
            $sub_menu_items = implode(',', $this->request->getVar('sub_menu_items'));
        }else
        {
            $sub_menu_items = '';
        }
        $parent_id = $this->request->getGet('id');
        $account_typeModel = new Account_typeModel();
        $data = [
            'at_title' => $this->request->getVar('title'),
            'at_code' => $this->request->getVar('code'),
            'at_menu_privileges'  => $mega_menu_ids,
            'at_menu_item_privileges'  => $sub_menu_items,
            'at_status'  => $this->request->getVar('status'),
            'at_updated_ip'  => $this->request->getIPAddress(),
            'at_updated_id' => dsession_id(),
            'at_updated_at' => date("Y-m-d h:i:s"),
        ];

        // echo "<pre>";
        // print_r($data);
        // exit();

        if($account_typeModel->where('at_id', $parent_id)->set($data)->update())
        {
            session()->setFlashdata("success", "Opration Successfull...");
            return $this->response->redirect(site_url('admin/account-type'));
        }else
        {
            session()->setFlashdata("error", "Opration Not Completed...");
            return $this->response->redirect(site_url('admin/account-type'));
        }
    }




	public function template($main_view)
	{
		echo view('Admin/include/header');
		echo view($main_view);
		echo view('Admin/include/footer');
	}

	


}

