<?php 
namespace App\Controllers\Admin;
use App\Models\CountryModel;
use App\Models\GenderModel;
use App\Models\Account_typeModel;
use App\Models\AccountModel;
use App\Models\StateModel;
use App\Models\CityModel;

use App\Controllers\BaseController;

class AccountController extends BaseController
{

	public function index()
	{
		$accounts = new AccountModel();
        $dyanmicData['accounts'] = $accounts->orderBy('ac_id', 'DESC')->join('account_type', 'ac_type = account_type.at_id')->findAll();

        echo view('Admin/include/header');
		echo view('Admin/account/list', $dyanmicData);
		echo view('Admin/include/footer');
        
	}

	public function add()
	{
        $genders = new GenderModel();
        $dyanmicData['genders'] = $genders->orderBy('gender_name', 'ASC')->where('gender_active','A')->findAll();

        $countrys = new CountryModel();
        $dyanmicData['countrys'] = $countrys->orderBy('country_name', 'ASC')->where('country_active','A')->findAll();

        $account_typeModel = new Account_typeModel();
        $dyanmicData['at_list'] = $account_typeModel->orderBy('at_id', 'DESC')->findAll();

        
        echo view('Admin/include/header');
        echo view('Admin/account/add', $dyanmicData);
        echo view('Admin/include/footer');
	}

	public function addConf()
	{
		// echo "<pre>";
		// print_r($this->request->getVar());
        // exit();

		$account = new AccountModel();

        if($this->request->getVar('password') == $this->request->getVar('re_type_password'))
        {

            $data = [
                'ac_fname' => $this->request->getVar('fname'),
                'ac_mname'  => $this->request->getVar('mname'),
                'ac_lname'  => $this->request->getVar('lname'),
                'ac_gender'  => $this->request->getVar('gender'),
                'ac_contact_no'  => $this->request->getVar('contact_no'),
                'ac_alt_contact_no'  => $this->request->getVar('alt_contact_no'),
                'ac_email'  => $this->request->getVar('email'),
                'ac_alt_email'  => $this->request->getVar('alt_email'),
                'ac_country'  => $this->request->getVar('country'),
                'ac_state'  => $this->request->getVar('state'),
                'ac_city'  => $this->request->getVar('city'),
                'ac_zip'  => $this->request->getVar('zip_code'),
                'ac_street_address'  => $this->request->getVar('street_address'),
                'ac_latitude'  => $this->request->getVar('latitude'),
                'ac_longitude'  => $this->request->getVar('longitude'),
                'ac_password'  => md5($this->request->getVar('password')),
                'ac_type'   => $this->request->getVar('account_type'),
                'ac_created_ip'  => $this->request->getIPAddress(),
                'ac_created_id' => dsession_id(),
                'ac_created_at' => date("Y-m-d h:i:s"),
                'ac_active'=> 'A'
            ];

            if($account->insert($data))
            {
                session()->setFlashdata("success", "Account Created Successfully...");
                return $this->response->redirect(site_url(uri_string()));
            }else
            {
                session()->setFlashdata("error", "Account Not Created...");
                return $this->response->redirect(site_url(uri_string()));
            }


        }else{
            session()->setFlashdata("error", "Password and Retype Password  Not Matched...");
            return $this->response->redirect(site_url(uri_string()));
        }   
        

        
	}

    public function edit()
    {
        $id = $this->request->getGet('id');
        $acData = new AccountModel();
        $dyanmicData['acdata'] = $acData->where('ac_id', $id)->first();
        $genders = new GenderModel();
        $dyanmicData['genders'] = $genders->orderBy('gender_name', 'ASC')->where('gender_active','A')->findAll();

        $states = new StateModel();
        $dyanmicData['state'] = $states->orderBy('state_title', 'ASC')->where(['state_active'=>'A', 'sate_country_id'=>$dyanmicData['acdata']['ac_country']])->findAll();

        $citys = new CityModel();
        $dyanmicData['citys'] = $citys->orderBy('city_name', 'ASC')->where(['city_active'=>'A', 'city_state_id'=>$dyanmicData['acdata']['ac_state']])->findAll();


        $countrys = new CountryModel();
        $dyanmicData['countrys'] = $countrys->orderBy('country_name', 'ASC')->where('country_active','A')->findAll();

        $account_typeModel = new Account_typeModel();
        $dyanmicData['at_list'] = $account_typeModel->orderBy('at_id', 'DESC')->findAll();

        echo view('Admin/include/header');
        echo view('Admin/account/edit', $dyanmicData);
        echo view('Admin/include/footer');
    }
    public function editConf()
    {
        
        $id = $this->request->getGet('id');
        $accountModel = new AccountModel();
        
        $data = [
                'ac_fname' => $this->request->getVar('fname'),
                'ac_mname'  => $this->request->getVar('mname'),
                'ac_lname'  => $this->request->getVar('lname'),
                'ac_gender'  => $this->request->getVar('gender'),
                'ac_contact_no'  => $this->request->getVar('contact_no'),
                'ac_alt_contact_no'  => $this->request->getVar('alt_contact_no'),
                'ac_email'  => $this->request->getVar('email'),
                'ac_alt_email'  => $this->request->getVar('alt_email'),
                'ac_country'  => $this->request->getVar('country'),
                'ac_state'  => $this->request->getVar('state'),
                'ac_city'  => $this->request->getVar('city'),
                'ac_zip'  => $this->request->getVar('zip_code'),
                'ac_street_address'  => $this->request->getVar('street_address'),
                'ac_latitude'  => $this->request->getVar('latitude'),
                'ac_longitude'  => $this->request->getVar('longitude'),
                'ac_type'   => $this->request->getVar('account_type'),
                'ac_updated_ip'  => $this->request->getIPAddress(),
                'ac_updated_id' => dsession_id(),
                'ac_updated_at' => date("Y-m-d h:i:s")
            ];


        if($accountModel->where('ac_id', $id)->set($data)->update())
        {
            session()->setFlashdata("success", "Opration Successfull...");
            return $this->response->redirect(site_url('admin/account'));
        }else
        {
            session()->setFlashdata("error", "Opration Not Completed...");
            return $this->response->redirect(site_url('admin/account'));
        }
    }



	public function template($main_view)
	{
		echo view('Admin/include/header');
		echo view($main_view);
		echo view('Admin/include/footer');
	}

	


}

