<?php  ?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title><?= $seo['title']; ?></title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="<?= $seo['keywords']; ?>" name="keywords">
    <meta content="<?= $seo['description']; ?>" name="description">

    <!-- Favicon -->
    <link href="img/favicon.icon" rel="icon">

    
    <!-- Icon Font Stylesheet -->
    <!-- <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet"> -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://unpkg.com/flickity@2/dist/flickity.min.css">

    <!-- Libraries Stylesheet -->
    <link href="<?= SITE_MEDIA ?>front/css/animate-design.css" rel="stylesheet">
    <link href="<?= SITE_MEDIA ?>front/css/owl.carousel.min.css" rel="stylesheet">
    <link href="<?= SITE_MEDIA ?>front/css/owl.theme.default.min.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="<?= SITE_MEDIA ?>front/css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="<?= SITE_MEDIA ?>front/css/style.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

<style>
    
.product_items_parent .img-fluid {
    max-width: 100%;
    height: auto;
    max-height: 252px;
    min-height: 252px;
    width:100%;
}


.menu-cart
{
    position: relative;
    padding: 15px;
    background: #eb5933;
    color: #fff;
    border-radius: 3px;
}
.menu-cart:hover
{
    color: #fff;
}

.menu-cart::after
{
    content: attr(data-after);;
    position: absolute;
    right: 5px;
    top: -2px;
}
.decrement_qty
{
    border-radius: 3px 0px 0px 3px !important;
}
.increment_qty
{
    border-radius: 0px 3px 3px 0px !important;
}



@media(max-width:  1190px)
{
    .dropdown-menu.small {
        position: absolute !important;
        height: 400px;
        width: 100%;
        top: 93px !important;
        text-align: center;
    }
    .dropdown-menu.small.show {
        display: block;
        position: absolute !important;
        height: 400px;
        width: 100%;
        top: 93px !important;
        text-align: center;
    }
    .dropdown-menu.small.show a
    {
        margin: auto;
    }
}






    
</style>



</head>

<body>
        <!-- Spinner Start -->
        <div id="spinner" class="show bg-white position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
            <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div>
        <!-- Spinner End -->


 <!-- Navbar Start -->
       <div class="container-fluid nav-bar bg-transparent navigation p-0 ">
      <nav class=" navbar-expand-lg bg-white navbar-light py-2 px-0 px-md-3">
         <div class="menu-icon ">
            <span class="fas fa-bars"></span>
         </div>
         <div class="back-icon">
             <span><i class="fas fa-angle-left"></i></span>
         </div>
         <div class="logo">
             <a href="<?= site_url() ?>"> <img class="img-fluid" src="<?= SITE_MEDIA ?>front/img/logo.png" alt="Icon" style=""></a>
         </div>
         <div class="mx-auto">
             <div class="nav-items">

                <?php displayMenuItems(getMenuItem('HEADER-PRIMARY-MENU'));  ?>

          
    <?php if(isset($_SESSION['isUserLoggedIn'])){  

                    $cartQTy = count(getCartQty());

                    ?>
                <li>
                    <a href="<?= site_url('cart') ?>"  title="Quotation Cart"><span class="menu-cart" data-after="<?= $cartQTy ; ?>"><i class="fa-solid fa-cart-shopping"></i></span></a>
                </li>
                <?php } ?>
                
                <?php if(session()->get('isUserLoggedIn')){ ?>
                    <!-- <li>
                        <a href="<?= site_url('user/logout') ?>" title="Logout">Logout</a>
                    </li> -->


                    <li class="dropdown has-megamenu abc">
                        <a href="#" class="dropdown-toggle" data-bs-toggle="dropdown">Profile</a><div class="dropdown-menu small xyz" role="menu">
                            <a href="<?= site_url('user/dashboard') ?>" class="d-block py-2 px-2">Dashboard</a>
                            <a href="<?= site_url('user/quotation-history') ?>" class="d-block py-2 px-2">Quotation History</a>
                             <a href="<?= site_url('user/change-password') ?>" class="d-block py-2 px-2">Change Password</a>
                             <a href="<?= site_url('user/profile') ?>" class="d-block py-2 px-2">Update Profile</a>
                             <a href="<?= site_url('user/logout') ?>" class="d-block py-2 px-2">Logout</a>
                            
                        </div>
                    </li>




                <?php }else{ 
                
                    if(!isset($_SESSION['isUserLoggedIn'])){
                ?>
                    <li>
                        <a href="<?= site_url('user/login') ?>" title="Login">Login</a>
                    </li>
                <?php } } ?>



            
         </div>
         </div>
         <div class="search-icon">
            <span class="fas fa-search"></span>
         </div>
         <div class="cancel-icon">
            <span class="fas fa-times"></span>
         </div>
         <form action="<?= site_url('search') ?>" align="right">
            <input type="search" class="search-data" name="q" placeholder="Search here" required>
            <button type="submit" class="fas fa-search res-search"></button>
         </form>
      </nav>

</div>

        <!-- Navbar End -->
