<?php $dynamicDatas['seo'] = [
            'title' => 'Cart',
            'description' => '',
            'keywords' => '',
        ];

 echo view('public/includes/header', $dynamicDatas); 
 ?>


<style type="text/css">
	
.bg-lights
{
	background: #f7f8f9;
}
.cart_qty_input {
    width: 35px;
    text-align: center;
    padding: 0px 3px;
    font-size: 12px;
}


.decrement_qty, .increment_qty {
    padding: 1px 9px;
    font-size: 17px;
    height: 29px;
}

.cart_table
{
	font-size: 13px;
	font-weight: normal;
}

</style>


<section class="container  py-5">
	<div class="row">
		<div class="col-md-12">
			 <h4>Quotation cart</h4>
		</div>

<?php 
	
	$total_area_array = [];
	$total_price = []; 

 ?>

		<div class="col-md-12 py-4 ">

			<?php foreach($list as $ls){ 

				array_push($total_area_array, ($ls->ci_total_area * $ls->ci_prod_qty));
				array_push($total_price, ($ls->ci_total_price*$ls->ci_prod_qty));

				$catDatas = getProductCategory($ls->pro_id);

				// echo "<pre>";
				// print_r($catDatas);
				// echo "</pre>";

				?>

			<div class="row shadow border bg-lights g-0 mb-4">
				<div class="col-md-5">
					<div class="d-flex">


						<?php $mainIMg = getProductImageBySKUID($ls->ci_sku_code);
							if($mainIMg){ ?>
							<img src="<?= SITE_MEDIA ?>uploads/images/product-images/<?= $ls->pro_id ?>/<?= $mainIMg->cwfpi_image; ?>" width="120px">
						<?php }else{

							if($catDatas->cwf_cat_id == "170"){ ?>
								<?php $mainIMg2 = getProductImageByID($ls->pro_main_image);

							if($mainIMg2)
							{ ?>
							<img src="<?= SITE_MEDIA ?>uploads/images/product-images/<?= $ls->pro_id ?>/<?= $mainIMg2->cwfpi_image; ?>" width="120px">
							<?php }else{ ?>
							<img src="<?= SITE_MEDIA ?>front/img/no-img.jpeg" width="120px">


							<?php } }else{ ?>
								<img src="<?= SITE_MEDIA ?>front/img/no-img.jpeg" width="120px">
							<?php } ?>

							
							<?php   } ?>



						<div class="p-3">
							<h4><?= $ls->pro_title ?></h4>
							<p class="mb-0"><b><?= $ls->ci_sku_code; ?></b></p>

							<p class="mb-0"><?= $ls->pro_subtitle ?></p>

							<?php if($catDatas->cwf_cat_id == "170"){  
                                
                                if(!empty($ls->ci_accessories_ids)){
								$parentData = getProductDataByAccessID($ls->ci_accessories_ids);

								?>
								<p>Main Product - <?= $parentData->pro_title ?></p>
							<?php } } ?>

						</div>
					</div>
				</div>
				<div class="col-md-2">
					
				</div>
				<!-- Qty -->

				<?php if($catDatas->cwf_cat_id == "170"){ ?>
				<div class="col-md-2 col-4 pt-0 pt-md-4 ps-3 ps-md-0 pb-4 pb-md-0">
					<div class="d-flex mt-3" style="max-width: 140px;">
						<button class="btn rounded-0 btn-primary decrement_qty" data-cart-token='<?= $ls->ci_id ?>'>-</button>
						<input type="tel" id="qty_<?= $ls->ci_id ?>"  name="" value="<?= $ls->ci_prod_qty ?>" data-cart-input-token='<?= $ls->ci_id ?>' class="form-control rounded-0 cart_qty_input">
						<button class="btn rounded-0 btn-primary increment_qty"  data-cart-token='<?= $ls->ci_id ?>'>+</button>
					</div>
				</div> 
			<?php } ?>


				<!-- Total -->
				<div class="col-md-3 col-12 pt-0 pt-md-4 pe-4 ps-3 pb-4 pb-md-0">
					<div class="float-start mt-3 mt-md-2">
						<?php if($catDatas->cwf_cat_id == "170"){ ?>
							<span class="d-block ">Price: £ <b><?= $ls->ci_total_price ?></b></span>
						<?php }else{ ?>
							<span class="d-block ">Total Area: <b><?= $ls->ci_total_area*$ls->ci_prod_qty ?> m<sup>2</sup></b></span>
						<?php } ?>

						<span class="d-block">Total Price: <b>£ <?= currency_filter($ls->ci_total_price*$ls->ci_prod_qty) ?> </b></span>
					</div>
					<div class="float-end  mt-4 mt-md-2">
						<a href="<?= site_url('cart/remove?token='.$ls->ci_hash) ?>" class="btn btn-danger btn-sm"><i class="fa-solid fa-trash"></i></a>
					</div>
				</div>

				<?php $cartCalRows = cartCalData($ls->ci_id); 

					if($cartCalRows){
				 ?>
 
				<div class="col-md-12 cart_table mt-2 px-2">
					<table class="table table-bordered table-responsive">
						<thead>
							<tr>
								<th>Room Type</th>
								<th>Unit</th>
								<th>Width</th>
								<th>Length</th>
								<th>Actual Area</th>
								<th>Order Size Area</th>
							</tr>
						</thead>
						<tbody>
							<?php foreach($cartCalRows as $cR){ ?>
								<tr>
									<td><?= $cR->cd_room_type ?></td>
									<td><?= $cR->cd_units ?></td>
									<td><?= $cR->cd_width ?></td>
									<td><?= $cR->cd_length ?></td>
									<td><?= currency_filter($cR->cd_actual_area) ?></td>
									<td><?= currency_filter($cR->cd_order_size_area) ?></td>
								</tr>
							<?php } ?>

						</tbody>
					</table>
				</div>

				<?php } ?>

			</div>

			

			<?php } ?>

			<?php if($list){ ?>
			<div class="row">
				<div class="col-md-8">
					
				</div>
				<div class="col-md-4 text-end">

					


					<span class="d-block">Total Area: <span class=" fw-bold total_area_b"><?= currency_filter(array_reduce($total_area_array,"calculateSum")); ?> m<sup>2</sup></span></span>
					<span class="d-block">Total Price: <span class="fw-bold total_area_price_b">£ <?= currency_filter(array_reduce($total_price,"calculateSum")); ?></span></span>
					<br>
					<a onclick="javascript: history.go(-1);" class="btn btn-warning btn-md px-4 rounded-0">Add More</a>
					<a href="<?= site_url('cart/complete') ?>" class="btn btn-success btn-md px-4 rounded-0">Continue</a>
				</div>
			</div>
			<?php } ?>
		</div>




		
	</div>
</section>





<script type="text/javascript">
	


$('.cart_qty_input').keyup(function(){
	const cartQty = $(this).val();
	if(cartQty >= 1)
	{
		const cart_id = $(this).data('cart-input-token');
		const qtyLastVale = parseInt(cartQty);
		$.ajax({
			url:'<?= site_url('cart/update?token=') ?>'+cart_id+'&qty='+qtyLastVale,
			method:'GET',
			success:function(res)
			{
				const lastRes = JSON.parse(res);
				console.log(lastRes);
				$('#qty_'+cart_id).val(qtyLastVale);
				$('.total_area_price_b').html(lastRes.total_price.toFixed(2) +"£");
				$('.total_area_b').html(lastRes.total_area.toFixed(2) +"m<sup>2</sup>");
			},error:function()
			{
				console.log('Error on Ajax Request');
			}
		});
	}else
	{
		console.log('Qty Not Valid');
	}
});







$('.decrement_qty').click(function(){
	const cart_id = $(this).data('cart-token');
	const qtyValue = $('#qty_'+cart_id).val();
	
	if(qtyValue)
	{
		if(qtyValue == 1)
		{
			$('#tr_'+cart_id).remove();
		}
		const qtyLastVale = qtyValue - 1;


		$.ajax({
			url:'<?= site_url('cart/update?token=') ?>'+cart_id+'&qty='+qtyLastVale,
			method:'GET',
			success:function(res)
			{
				const lastRes = JSON.parse(res);
				console.log(lastRes);
				$('#qty_'+cart_id).val(qtyLastVale);

				$('.total_area_price_b').html(lastRes.total_price.toFixed(2) +"£");
				$('.total_area_b').html(lastRes.total_area.toFixed(2) +"m<sup>2</sup>");
			},error:function()
			{
				console.log('Error on Ajax Request');
			}
		});

	}

});


$('.increment_qty').click(function(){
	const cart_id = $(this).data('cart-token');
	const qtyValue = $('#qty_'+cart_id).val();
	
	if(qtyValue)
	{
		
		const qtyLastVale = parseInt(qtyValue) + 1;


		$.ajax({
			url:'<?= site_url('cart/update?token=') ?>'+cart_id+'&qty='+qtyLastVale,
			method:'GET',
			success:function(res)
			{
				const lastRes = JSON.parse(res);
				console.log(lastRes);
				$('#qty_'+cart_id).val(qtyLastVale);
				$('.total_area_price_b').html(lastRes.total_price.toFixed(2) +"£");
				$('.total_area_b').html(lastRes.total_area.toFixed(2) +"m<sup>2</sup>");
			},error:function()
			{
				console.log('Error on Ajax Request');
			}
		});

	}

});


</script>




<?php echo view('public/includes/footer'); ?>
