<?php 
$uri = current_url(true); 
$sub_title = ucwords(str_replace('-',' ', $uri->getSegment(2)));

?>

<?php 


$menu_type = [
				[
					'value' => '',
					'title' => 'Select',
				],
				[
					'value' => 'normal',
					'title' => 'Normal',
				],
				[
					'value' => 'page',
					'title' => 'Page',
				],
				[
					'value' => 'mega-menu',
					'title' => 'Mega Menu',
				],
			];


 ?>



<form action="<?= current_url().'?action=create&parent='.$_GET['parent']; ?>" method="post">

	<div class="row bg-light p-3">
		<div class="col-md-12 mb-3">
			<a href="<?= base_url($uri->getSegment(1).'/'.$uri->getSegment(2)) ?>" class="float-end btn btn-primary rounded-0 btn-sm"><?php echo $sub_title; ?> List</a>
		</div>
		<div class="col-md-4  mb-3">
			<label class="form-label">Parent Menu</label>
			<select name="parent_menu" id="" class="form-select rounded-0">
				<option value="">Select</option>
				<?php
					foreach($list as $l)
					{
						echo '<option value="'.$l->fem_id.'">'.$l->fem_name.'</option>';
					}
				 ?>
			</select>
		</div>
		<div class="col-md-4 mb-3">
			<label class="form-label">Type<sup class="text-danger fw-bold">*</sup></label>
			<select name="type" id="menu_type" class="form-select rounded-0" required>
				<?php
					foreach($menu_type as $mt)
					{
						echo '<option value="'.$mt['value'].'">'.$mt['title'].'</option>';
					}
				 ?>
			</select>
		</div>
		<div class="col-md-4 mb-3">
			<label class="form-label">Title </label>
			<input type="text" class="form-control rounded-0" id="title_input" name="title" >
		</div>

		<div class="col-md-12">
			<div class="row" id="dynamic_form">
				
			</div>
		</div>


		
		

		
		


		<div class="col-md-6 mb-3">
			<label class="form-label d-block mb-3">Options </label>
		
			<input type="checkbox" class="form-check-input rounded-0" value="yes" name="open_new_tab">
			<label>Open New Tab</label>
		</div>
		<div class="col-md-6 mb-3">
			<label class="form-label">Status</label>
			<select name="status" id="" class="form-select rounded-0">
				<option value="A">Active</option>
				<option value="D">Draft</option>
			</select>
		</div>
		
		<div class="col-md-12">
			<button type="submit" class="btn btn-success rounded-0 btn-sm">Save</button>
		</div>
	</div>

</form>











<script type="text/javascript">
	

$(document).ready(function(){
	$('#menu_type').change(function(){
		const type = $(this).val();

		if(type == 'normal')
		{
			 $("#title_input").prop('required',true);
			$('#dynamic_form').html('<div class="col-md-12 mb-3"><label class="form-label">Link <sup class="text-danger fw-bold">*</sup></label><input type="text" class="form-control rounded-0" name="link" required></div>');

		}else if(type == 'page')
		{
			 $("#title_input").prop('required',false);
			$('#dynamic_form').html('<div class="col-md-12 mb-3"><label class="form-label">Page<sup class="text-danger fw-bold">*</sup></label><select name="page" id="" class="form-select rounded-0" required><?php
					foreach($page_list as $pl)
					{
						echo '<option value="'.$pl['page_id'].'">'.$pl['page_title'].'</option>';
					}
				 ?></select></div>');
		}else if(type == 'mega-menu')
		{
			$("#title_input").prop('required',false);
			$('#dynamic_form').html('<div class="col-md-12 mb-3"><label class="form-label">Sections<sup class="text-danger fw-bold">*</sup></label><select name="section" id="" class="form-select rounded-0" required><?php
					foreach($section_list as $sl)
					{
						echo '<option value="'.$sl->section_id.'">'.$sl->section_name.'</option>';
					}
				 ?></select></div>');
		}else
		{
			$("#title_input").prop('required',false);
			$('#dynamic_form').html('');
		}

	})
});

</script>





